/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml.parser;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.filters.yaml.parser.IndentedBlock;
import net.sf.okapi.filters.yaml.parser.Line;
import net.sf.okapi.filters.yaml.parser.QuotedScalar;
import net.sf.okapi.filters.yaml.parser.YamlChompTypes;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;

public class Scalar {
    public int parentIndent = -1;
    public YamlScalarTypes type = YamlScalarTypes.UNKOWN;
    public YamlChompTypes chomp = YamlChompTypes.NONE;
    public String blockType;
    public String scalar = null;
    public QuotedScalar quoted = null;
    public IndentedBlock indentedBlock = null;
    public boolean flow = false;

    public void setChomp(String blockType) {
        this.blockType = blockType;
        this.chomp = blockType.contains("+") ? YamlChompTypes.PLUS : (blockType.contains("-") ? YamlChompTypes.MINUS : YamlChompTypes.NONE);
    }

    public boolean isEmpty() {
        return this.scalar == null && this.indentedBlock.isEmpty() && this.quoted.isEmpty();
    }

    public List<Line> getTranslatableStrings() {
        LinkedList<Line> lines = new LinkedList<Line>();
        if (this.quoted != null && !this.quoted.isEmpty()) {
            return this.quoted.getTranslatableStrings();
        }
        if (this.indentedBlock == null || this.indentedBlock.isEmpty()) {
            lines.add(new Line(this.scalar, false));
            return lines;
        }
        if (this.indentedBlock != null && !this.indentedBlock.isEmpty()) {
            lines.addAll(this.indentedBlock.getTranslatableStrings());
        }
        if (this.scalar != null && !lines.isEmpty()) {
            Line f = (Line)lines.get(0);
            assert (!f.isSkeleton);
            f.line = this.scalar + " " + f.line;
        }
        return lines;
    }

    public String getOriginalString() {
        StringBuilder s = new StringBuilder();
        if (this.quoted != null) {
            return this.quoted.getOriginalString();
        }
        if (this.scalar != null) {
            s.append(this.scalar);
        }
        if (this.indentedBlock != null) {
            s.append(this.indentedBlock.getOriginalString());
        }
        return s.toString();
    }
}

