/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;
import net.sf.okapi.filters.openxml.WordStyleDefinition;

class WordStyleDefinitionsReader
implements StyleDefinitionsReader {
    private static final String UNEXPECTED_STRUCTURE = "Unexpected styles structure: ";
    private final ConditionalParameters conditionalParameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private final Reader reader;
    private final Cache cache;

    WordStyleDefinitionsReader(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory, Reader reader) {
        this.conditionalParameters = conditionalParameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
        this.reader = reader;
        this.cache = new Cache();
    }

    @Override
    public StartDocument readStartDocument() throws XMLStreamException {
        if (this.cache.hasStartDocument()) {
            return this.cache.startDocument;
        }
        this.cache.eventReader = this.inputFactory.createXMLEventReader(this.reader);
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isStartDocument()) continue;
            this.cache.startDocument = (StartDocument)event;
            return this.cache.startDocument;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start document event is absent"));
    }

    @Override
    public StartElement readStartElement() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readStartDocument();
        }
        if (this.cache.hasStartElement()) {
            return this.cache.startElement;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isStartElement() || !"styles".equals(event.asStartElement().getName().getLocalPart())) continue;
            this.cache.startElement = event.asStartElement();
            return this.cache.startElement;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the start element is absent"));
    }

    WordStyleDefinition readDocumentDefaults() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readStartElement();
        }
        if (this.cache.hasDocumentDefaults()) {
            return this.cache.documentDefaults;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (event.isStartElement() && "docDefaults".equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.documentDefaults = new WordStyleDefinition.DocumentDefaults(this.conditionalParameters, this.eventFactory, event.asStartElement());
                this.cache.documentDefaults.readWith(this.cache.eventReader);
                return this.cache.documentDefaults;
            }
            if (event.isStartElement() && "latentStyles".equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.latentStyles = new WordStyleDefinition.Latent(this.eventFactory, event.asStartElement());
                this.cache.latentStyles.readWith(this.cache.eventReader);
                break;
            }
            if (event.isStartElement() && "style".equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.generalStyleStartElement = event.asStartElement();
                break;
            }
            if (!event.isEndElement() || !"styles".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            break;
        }
        this.cache.documentDefaults = new WordStyleDefinition.Empty();
        return this.cache.documentDefaults;
    }

    WordStyleDefinition readLatent() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readDocumentDefaults();
        }
        if (this.cache.hasLatentStyles()) {
            return this.cache.latentStyles;
        }
        if (this.cache.hasGeneralStyleStartElement()) {
            this.cache.latentStyles = new WordStyleDefinition.Empty();
            return this.cache.latentStyles;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (event.isStartElement() && "latentStyles".equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.latentStyles = new WordStyleDefinition.Latent(this.eventFactory, event.asStartElement());
                this.cache.latentStyles.readWith(this.cache.eventReader);
                return this.cache.latentStyles;
            }
            if (event.isStartElement() && "style".equals(event.asStartElement().getName().getLocalPart())) {
                this.cache.generalStyleStartElement = event.asStartElement();
                break;
            }
            if (!event.isEndElement() || !"styles".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            break;
        }
        this.cache.latentStyles = new WordStyleDefinition.Empty();
        return this.cache.latentStyles;
    }

    boolean hasNextGeneral() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readLatent();
        }
        if (this.cache.hasGeneralStyleStartElement()) {
            return true;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.peek();
            if (event.isStartElement() && "style".equals(event.asStartElement().getName().getLocalPart())) {
                return true;
            }
            if (event.isEndElement() && "styles".equals(event.asEndElement().getName().getLocalPart())) {
                this.cache.endElement = event.asEndElement();
                this.cache.eventReader.nextEvent();
                return false;
            }
            this.cache.eventReader.nextEvent();
        }
        return false;
    }

    WordStyleDefinition readNextGeneral() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readLatent();
        }
        if (this.cache.hasGeneralStyleStartElement()) {
            WordStyleDefinition.General styleDefinition = this.wordStyleDefinition(this.cache.generalStyleStartElement);
            styleDefinition.readWith(this.cache.eventReader);
            this.cache.invalidateGeneralStyleStartElement();
            return styleDefinition;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (event.isStartElement() && "style".equals(event.asStartElement().getName().getLocalPart())) {
                WordStyleDefinition.General styleDefinition = this.wordStyleDefinition(event.asStartElement());
                styleDefinition.readWith(this.cache.eventReader);
                return styleDefinition;
            }
            if (!event.isEndElement() || !"styles".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            return new WordStyleDefinition.Empty();
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the style-start and styles-end elements are absent"));
    }

    private WordStyleDefinition.General wordStyleDefinition(StartElement startElement) {
        return new WordStyleDefinition.General(this.conditionalParameters, this.eventFactory, startElement);
    }

    @Override
    public EndElement readEndElement() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readLatent();
        }
        if (this.cache.hasEndElement()) {
            return this.cache.endElement;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isEndElement() || !"styles".equals(event.asEndElement().getName().getLocalPart())) continue;
            this.cache.endElement = event.asEndElement();
            return this.cache.endElement;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE.concat("the end element is absent"));
    }

    @Override
    public EndDocument readEndDocument() throws XMLStreamException {
        if (!this.cache.hasEventReader()) {
            this.readEndElement();
        }
        if (this.cache.hasEndDocument()) {
            return this.cache.endDocument;
        }
        while (this.cache.eventReader.hasNext()) {
            XMLEvent event = this.cache.eventReader.nextEvent();
            if (!event.isEndDocument()) continue;
            this.cache.endDocument = (EndDocument)event;
            return this.cache.endDocument;
        }
        this.cache.endDocument = this.eventFactory.createEndDocument();
        return this.cache.endDocument;
    }

    static class Cache {
        private XMLEventReader eventReader;
        private StartDocument startDocument;
        private StartElement startElement;
        private WordStyleDefinition documentDefaults;
        private WordStyleDefinition latentStyles;
        private StartElement generalStyleStartElement;
        private EndElement endElement;
        private EndDocument endDocument;

        Cache() {
        }

        boolean hasEventReader() {
            return null != this.eventReader;
        }

        boolean hasStartDocument() {
            return null != this.startDocument;
        }

        boolean hasStartElement() {
            return null != this.startElement;
        }

        boolean hasDocumentDefaults() {
            return null != this.documentDefaults;
        }

        boolean hasLatentStyles() {
            return null != this.latentStyles;
        }

        boolean hasGeneralStyleStartElement() {
            return null != this.generalStyleStartElement;
        }

        void invalidateGeneralStyleStartElement() {
            this.generalStyleStartElement = null;
        }

        boolean hasEndElement() {
            return null != this.endElement;
        }

        boolean hasEndDocument() {
            return null != this.endDocument;
        }
    }
}

