/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinition;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface WordStyleDefinition
extends StyleDefinition {
    public static final String UNEXPECTED_STRUCTURE = "Unexpected structure : ";
    public static final String EMPTY = "";
    public static final String RPR = "rPr";

    public StyleType type();

    public String id();

    public boolean isDefault();

    public String parentId();

    public void parentId(String var1);

    public String linkedId();

    public void runProperties(RunProperties var1);

    public static class General
    implements WordStyleDefinition {
        static final String TYPE = "type";
        static final String STYLE_ID = "styleId";
        static final String DEFAULT = "default";
        private static final String NAME = "name";
        private static final String BASED_ON = "basedOn";
        private static final String LINK = "link";
        private static final String VAL = "val";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private StyleType type;
        private String id;
        private boolean shouldBeDefault;
        private String parentId;
        private String linkedId;
        private List<XMLEvent> eventsBeforeParagraphProperties;
        private BlockProperties paragraphProperties;
        private List<XMLEvent> eventsBeforeRunProperties;
        private RunProperties runProperties;
        private List<XMLEvent> eventsBeforeTableProperties;
        private BlockProperties tableProperties;
        private List<XMLEvent> eventsBeforeEndElement;
        private EndElement endElement;
        private boolean attributesRead;

        General(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public StyleType type() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.type;
        }

        @Override
        public String id() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.id;
        }

        @Override
        public boolean isDefault() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.shouldBeDefault;
        }

        @Override
        public String parentId() {
            return this.parentId;
        }

        @Override
        public void parentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public String linkedId() {
            return this.linkedId;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.readAttributes();
            this.readElements(reader);
        }

        private void readAttributes() {
            this.readType();
            this.readStyleId();
            this.readDefault();
            this.attributesRead = true;
        }

        private void readType() {
            this.type = StyleType.fromString(XMLEventHelpers.getAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), TYPE, this.startElement.getName().getPrefix())));
            if (this.type == StyleType.UNSUPPORTED) {
                this.type = StyleType.PARAGRAPH;
            }
        }

        private void readStyleId() {
            this.id = XMLEventHelpers.getAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), STYLE_ID, this.startElement.getName().getPrefix()));
        }

        private void readDefault() {
            this.shouldBeDefault = XMLEventHelpers.getBooleanAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), DEFAULT, this.startElement.getName().getPrefix()), XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE);
        }

        private void readElements(XMLEventReader reader) throws XMLStreamException {
            List<XMLEvent> currentEvents = this.eventsBeforeParagraphProperties = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    if (null == this.paragraphProperties || this.paragraphProperties.isEmpty()) {
                        this.paragraphProperties = new BlockProperties.Empty(this.startElement(this.paragraphProperties, "pPr"));
                    }
                    if (null == this.runProperties || 0 == this.runProperties.count()) {
                        this.runProperties = new RunProperties.Empty();
                    }
                    if (StyleType.TABLE == this.type && (null == this.tableProperties || this.tableProperties.isEmpty())) {
                        this.tableProperties = new BlockProperties.Empty(this.startElement(this.tableProperties, "tblPr"));
                    }
                    this.endElement = event.asEndElement();
                    return;
                }
                if (event.isStartElement()) {
                    String localPart = event.asStartElement().getName().getLocalPart();
                    if (BASED_ON.equals(localPart)) {
                        this.parentId = XMLEventHelpers.getAttributeValue(event.asStartElement(), XMLEventHelpers.WPML_VAL);
                    } else if (LINK.equals(localPart)) {
                        this.linkedId = XMLEventHelpers.getAttributeValue(event.asStartElement(), XMLEventHelpers.WPML_VAL);
                    } else {
                        if ("pPr".equals(localPart)) {
                            this.paragraphProperties = this.blockProperties(event.asStartElement(), reader);
                            this.eventsBeforeRunProperties = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeRunProperties;
                            continue;
                        }
                        if (WordStyleDefinition.RPR.equals(localPart)) {
                            this.runProperties = this.runProperties(event.asStartElement(), reader);
                            this.eventsBeforeTableProperties = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeTableProperties;
                            continue;
                        }
                        if ("tblPr".equals(localPart)) {
                            this.tableProperties = this.blockProperties(event.asStartElement(), reader);
                            this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeEndElement;
                            continue;
                        }
                        if ("trPr".equals(localPart) || "tcPr".equals(localPart)) {
                            if (null == this.eventsBeforeEndElement) {
                                this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                                currentEvents = this.eventsBeforeEndElement;
                            }
                        } else if ("tblStylePr".equals(localPart)) {
                            if (null == this.eventsBeforeEndElement) {
                                this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                                currentEvents = this.eventsBeforeEndElement;
                            }
                            currentEvents.add(event);
                            currentEvents.addAll(this.eventsToEndElement(reader, "tblStylePr"));
                            continue;
                        }
                    }
                }
                currentEvents.add(event);
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        private StartElement startElement(BlockProperties blockProperties, String name) {
            if (null != blockProperties) {
                return blockProperties.startElement();
            }
            return this.eventFactory.createStartElement(new QName(this.startElement.getName().getNamespaceURI(), name, this.startElement.getName().getPrefix()), null, null);
        }

        private BlockProperties blockProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            return new MarkupComponentParser().parseBlockProperties(StartElementContextFactory.createStartElementContext(startElement, null, reader, this.eventFactory, this.conditionalParameters), new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI, SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI_VISUAL, SkippableElement.RunProperty.RUN_PROPERTY_RTL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE), this.conditionalParameters));
        }

        private RunProperties runProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(startElement, null, reader, this.eventFactory, this.conditionalParameters);
            return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        private List<XMLEvent> eventsToEndElement(XMLEventReader reader, String name) throws XMLStreamException {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                events.add(event);
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(name)) continue;
                return events;
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(name).concat(" end element is absent"));
        }

        @Override
        public RunProperties runProperties() {
            return this.runProperties;
        }

        @Override
        public void runProperties(RunProperties runProperties) {
            this.runProperties = runProperties;
        }

        @Override
        public Markup toMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            if (null == this.eventsBeforeParagraphProperties) {
                this.readElements();
            }
            markup.addComponent(new MarkupComponent.General(this.eventsBeforeParagraphProperties));
            if (null != this.paragraphProperties) {
                markup.addComponent(this.paragraphProperties);
            }
            if (null != this.eventsBeforeRunProperties) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeRunProperties));
            }
            markup.addComponent(this.runProperties);
            if (null != this.eventsBeforeTableProperties) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeTableProperties));
            }
            if (null != this.tableProperties) {
                markup.addComponent(this.tableProperties);
            }
            if (null != this.eventsBeforeEndElement) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeEndElement));
            }
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }

        private void readElements() {
            this.eventsBeforeParagraphProperties = new LinkedList<XMLEvent>();
            this.readNameElement();
            this.readBasedOnElement();
            this.readEndElement();
        }

        private void readNameElement() {
            this.readElementWith(NAME, this.id());
        }

        private void readBasedOnElement() {
            this.readElementWith(BASED_ON, this.parentId);
        }

        private void readElementWith(String name, String value) {
            if (null == value) {
                return;
            }
            List<Attribute> attributes = Collections.singletonList(this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), VAL, this.startElement.getName().getPrefix()), value));
            this.eventsBeforeParagraphProperties.add(this.eventFactory.createStartElement(new QName(this.startElement.getName().getNamespaceURI(), name, this.startElement.getName().getPrefix()), attributes.iterator(), null));
            this.eventsBeforeParagraphProperties.add(this.eventFactory.createEndElement(new QName(this.startElement.getName().getNamespaceURI(), name, this.startElement.getName().getPrefix()), null));
        }

        private void readEndElement() {
            this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), null);
        }
    }

    public static class Latent
    implements WordStyleDefinition {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private List<XMLEvent> innerEvents;
        private EndElement endElement;

        Latent(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.innerEvents = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = event.asEndElement();
                    return;
                }
                this.innerEvents.add(event);
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StyleType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String parentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void parentId(String parentId) {
        }

        @Override
        public String linkedId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void runProperties(RunProperties runProperties) {
        }

        @Override
        public Markup toMarkup() {
            if (this.innerEvents.isEmpty()) {
                return new Markup.Empty();
            }
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            markup.addComponent(new MarkupComponent.General(this.innerEvents));
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }
    }

    public static class DocumentDefaults
    implements WordStyleDefinition {
        static final String PPR_DEFAULT = "pPrDefault";
        static final String RPR_DEFAULT = "rPrDefault";
        private static final String PPR = "pPr";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private StartElement paragraphPropertiesDefaultStartElement;
        private BlockProperties paragraphProperties;
        private EndElement paragraphPropertiesDefaultEndElement;
        private StartElement runPropertiesDefaultStartElement;
        private RunProperties runProperties;
        private EndElement runPropertiesDefaultEndElement;
        private EndElement endElement;

        DocumentDefaults(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement()) {
                    if (event.asEndElement().getName().equals(this.startElement.getName())) {
                        this.endElement = event.asEndElement();
                        return;
                    }
                    if (event.asEndElement().getName().getLocalPart().equals(PPR_DEFAULT)) {
                        this.paragraphPropertiesDefaultEndElement = event.asEndElement();
                        continue;
                    }
                    if (!event.asEndElement().getName().getLocalPart().equals(RPR_DEFAULT)) continue;
                    this.runPropertiesDefaultEndElement = event.asEndElement();
                    continue;
                }
                if (!event.isStartElement()) continue;
                switch (event.asStartElement().getName().getLocalPart()) {
                    case "pPrDefault": {
                        this.paragraphPropertiesDefaultStartElement = event.asStartElement();
                        break;
                    }
                    case "rPrDefault": {
                        this.runPropertiesDefaultStartElement = event.asStartElement();
                        break;
                    }
                    case "pPr": {
                        this.paragraphProperties = this.paragraphProperties(reader, event);
                        break;
                    }
                    case "rPr": {
                        this.runProperties = this.runProperties(reader, event);
                    }
                }
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        private BlockProperties paragraphProperties(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            return new MarkupComponentParser().parseBlockProperties(StartElementContextFactory.createStartElementContext(event.asStartElement(), null, reader, this.eventFactory, this.conditionalParameters), new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI, SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI_VISUAL, SkippableElement.RunProperty.RUN_PROPERTY_RTL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE), this.conditionalParameters));
        }

        private RunProperties runProperties(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(event.asStartElement(), null, reader, this.eventFactory, this.conditionalParameters);
            return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StyleType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String parentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void parentId(String parentId) {
        }

        @Override
        public String linkedId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            return this.runProperties;
        }

        @Override
        public void runProperties(RunProperties runProperties) {
            this.runProperties = runProperties;
        }

        @Override
        public Markup toMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            if (null != this.paragraphPropertiesDefaultStartElement && null != this.paragraphPropertiesDefaultEndElement) {
                markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.paragraphPropertiesDefaultStartElement));
                if (null != this.paragraphProperties) {
                    markup.addComponent(this.paragraphProperties);
                }
                markup.addComponent(new MarkupComponent.End(this.paragraphPropertiesDefaultEndElement));
            }
            if (null != this.runPropertiesDefaultStartElement && null != this.runProperties && null != this.runPropertiesDefaultEndElement) {
                markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.runPropertiesDefaultStartElement));
                markup.addComponent(this.runProperties);
                markup.addComponent(new MarkupComponent.End(this.runPropertiesDefaultEndElement));
            }
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }
    }

    public static class Empty
    implements WordStyleDefinition {
        @Override
        public void readWith(XMLEventReader reader) {
        }

        @Override
        public String id() {
            return WordStyleDefinition.EMPTY;
        }

        @Override
        public StyleType type() {
            return StyleType.UNSUPPORTED;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public String parentId() {
            return null;
        }

        @Override
        public void parentId(String parentId) {
        }

        @Override
        public String linkedId() {
            return null;
        }

        @Override
        public RunProperties runProperties() {
            return new RunProperties.Empty();
        }

        @Override
        public void runProperties(RunProperties runProperties) {
        }

        @Override
        public Markup toMarkup() {
            return new Markup.Empty();
        }
    }
}

