/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.XMLEvents;

interface Markup
extends XMLEvents {
    public void addComponent(MarkupComponent var1);

    public void addComponents(List<MarkupComponent> var1);

    public void addMarkup(Markup var1);

    public List<MarkupComponent> components();

    public Nameable nameableComponent();

    public static class General
    implements Markup {
        private final List<MarkupComponent> components;

        General(List<MarkupComponent> components) {
            this.components = components;
        }

        @Override
        public void addComponent(MarkupComponent component) {
            this.components.add(component);
        }

        @Override
        public void addComponents(List<MarkupComponent> components) {
            this.components.addAll(components);
        }

        @Override
        public void addMarkup(Markup markup) {
            this.components.addAll(markup.components());
        }

        @Override
        public List<MarkupComponent> components() {
            return this.components;
        }

        @Override
        public Nameable nameableComponent() {
            for (MarkupComponent markupComponent : this.components) {
                if (!(markupComponent instanceof Nameable)) continue;
                return (Nameable)((Object)markupComponent);
            }
            return null;
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            for (MarkupComponent component : this.components) {
                events.addAll(component.getEvents());
            }
            return events;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.components.size() + ") " + this.components;
        }
    }

    public static class Empty
    implements Markup {
        @Override
        public void addComponent(MarkupComponent component) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addComponents(List<MarkupComponent> components) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMarkup(Markup markup) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MarkupComponent> components() {
            return Collections.emptyList();
        }

        @Override
        public Nameable nameableComponent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }
    }
}

