/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.BlockPropertyFactory;
import net.sf.okapi.filters.openxml.ClarifiableAttribute;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifierStrategy;

abstract class BlockPropertiesClarifierStrategy
extends MarkupComponentClarifierStrategy {
    protected String blockPropertiesName;

    BlockPropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, ClarifiableAttribute clarifiableAttribute, String blockPropertiesName) {
        super(conditionalParameters, creationalParameters, clarificationParameters, clarifiableAttribute);
        this.blockPropertiesName = blockPropertiesName;
    }

    abstract void clarifyBlockProperties(ListIterator<MarkupComponent> var1);

    protected MarkupComponent getMarkupComponent(ListIterator<MarkupComponent> markupComponentIterator) {
        if (!markupComponentIterator.hasNext()) {
            if (!this.clarificationParameters.shouldBeBidirectional()) {
                return null;
            }
            this.addBlockProperties(markupComponentIterator);
            return null;
        }
        MarkupComponent markupComponent = markupComponentIterator.next();
        if (!(markupComponent instanceof BlockProperties) || !this.blockPropertiesName.equals(((BlockProperties)markupComponent).getName().getLocalPart())) {
            if (!this.clarificationParameters.shouldBeBidirectional()) {
                return null;
            }
            markupComponentIterator.previous();
            this.addBlockProperties(markupComponentIterator);
            return null;
        }
        return markupComponent;
    }

    protected abstract void addBlockProperties(ListIterator<MarkupComponent> var1);

    static abstract class PropertiesClarifierStrategy
    extends BlockPropertiesClarifierStrategy {
        private static final int DEFAULT_BLOCK_PROPERTIES_SIZE = 1;
        private static final String DEFAULT_CLARIFIABLE_ATTRIBUTE_PREFIX = "";
        private static final String DEFAULT_CLARIFIABLE_ATTRIBUTE_NAME = "";
        private static final ClarifiableAttribute DEFAULT_CLARIFIABLE_ATTRIBUTE = new ClarifiableAttribute("", "", Collections.emptySet());
        private String clarifiablePropertyName;

        PropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, String blockPropertiesName, String clarifiablePropertyName) {
            super(conditionalParameters, creationalParameters, clarificationParameters, DEFAULT_CLARIFIABLE_ATTRIBUTE, blockPropertiesName);
            this.clarifiablePropertyName = clarifiablePropertyName;
        }

        @Override
        void clarifyBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
            MarkupComponent markupComponent = this.getMarkupComponent(markupComponentIterator);
            if (null == markupComponent) {
                return;
            }
            ListIterator<BlockProperty> blockPropertyIterator = ((BlockProperties)markupComponent).properties().listIterator();
            while (blockPropertyIterator.hasNext()) {
                BlockProperty blockProperty = blockPropertyIterator.next();
                if (!this.clarifiablePropertyName.equals(blockProperty.getName().getLocalPart())) continue;
                if (!this.clarificationParameters.shouldBeBidirectional()) {
                    this.removeBlockProperty(markupComponentIterator, (BlockProperties)markupComponent, blockPropertyIterator);
                    return;
                }
                return;
            }
            if (this.clarificationParameters.shouldBeBidirectional()) {
                this.addBlockProperty(blockPropertyIterator);
            }
        }

        List<BlockProperty> createRequiredBlockProperties() {
            ArrayList<BlockProperty> blockProperties = new ArrayList<BlockProperty>(1);
            blockProperties.add(BlockPropertyFactory.createBlockProperty(this.creationalParameters, this.clarifiablePropertyName, Collections.emptyMap()));
            return blockProperties;
        }

        private void addBlockProperty(ListIterator<BlockProperty> blockPropertyIterator) {
            blockPropertyIterator.add(BlockPropertyFactory.createBlockProperty(this.creationalParameters, this.clarifiablePropertyName, Collections.emptyMap()));
        }

        private void removeBlockProperty(ListIterator<MarkupComponent> markupComponentIterator, BlockProperties blockProperties, ListIterator<BlockProperty> blockPropertyIterator) {
            blockPropertyIterator.remove();
            if (blockProperties.attributes().isEmpty() && blockProperties.properties().isEmpty()) {
                markupComponentIterator.remove();
            }
        }

        static class TablePropertiesClarifierStrategy
        extends PropertiesClarifierStrategy {
            TablePropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
                super(conditionalParameters, creationalParameters, clarificationParameters, "tblPr", "bidiVisual");
            }

            @Override
            protected void addBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
                markupComponentIterator.add(BlockPropertiesFactory.createTableProperties(this.conditionalParameters, this.creationalParameters, Collections.emptyList(), this.createRequiredBlockProperties()));
            }
        }

        static class ParagraphPropertiesClarifierStrategy
        extends PropertiesClarifierStrategy {
            ParagraphPropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
                super(conditionalParameters, creationalParameters, clarificationParameters, "pPr", "bidi");
            }

            @Override
            protected void addBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
                markupComponentIterator.add(BlockPropertiesFactory.createParagraphProperties(this.conditionalParameters, this.creationalParameters, this.createRequiredBlockProperties()));
            }
        }
    }

    static abstract class AttributesClarifierStrategy
    extends BlockPropertiesClarifierStrategy {
        AttributesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, ClarifiableAttribute clarifiableAttribute, String blockPropertiesName) {
            super(conditionalParameters, creationalParameters, clarificationParameters, clarifiableAttribute, blockPropertiesName);
        }

        @Override
        void clarifyBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
            MarkupComponent markupComponent = this.getMarkupComponent(markupComponentIterator);
            if (null == markupComponent) {
                return;
            }
            super.clarifyMarkupComponent(markupComponent);
        }

        static class TextBodyPropertiesClarifierStrategy
        extends AttributesClarifierStrategy {
            TextBodyPropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, ClarifiableAttribute clarifiableAttribute) {
                super(conditionalParameters, creationalParameters, clarificationParameters, clarifiableAttribute, "bodyPr");
            }

            @Override
            protected void addBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
                markupComponentIterator.add(BlockPropertiesFactory.createTextBodyProperties(this.conditionalParameters, this.creationalParameters, Collections.singletonList(this.createRequiredAttribute())));
            }
        }

        static class TablePropertiesClarifierStrategy
        extends AttributesClarifierStrategy {
            TablePropertiesClarifierStrategy(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, ClarificationParameters clarificationParameters, ClarifiableAttribute clarifiableAttribute) {
                super(conditionalParameters, creationalParameters, clarificationParameters, clarifiableAttribute, "tblPr");
            }

            @Override
            protected void addBlockProperties(ListIterator<MarkupComponent> markupComponentIterator) {
                markupComponentIterator.add(BlockPropertiesFactory.createTableProperties(this.conditionalParameters, this.creationalParameters, Collections.singletonList(this.createRequiredAttribute()), Collections.emptyList()));
            }
        }
    }
}

