/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertiesParser;
import net.sf.okapi.filters.idml.StyleRange;

class StyleRangeParser {
    private final StartElement startElement;
    private final XMLEventReader eventReader;

    StyleRangeParser(StartElement startElement, XMLEventReader eventReader) {
        this.startElement = startElement;
        this.eventReader = eventReader;
    }

    StyleRange parse() throws XMLStreamException {
        StyleRange.StyleRangeBuilder styleRangeBuilder = new StyleRange.StyleRangeBuilder();
        styleRangeBuilder.setAttributes(ParsingIdioms.getStartElementAttributes(this.startElement));
        XMLEvent nextEvent = this.eventReader.peek();
        if (nextEvent.isEndElement()) {
            if (!nextEvent.asEndElement().getName().equals(this.startElement.getName())) {
                throw new IllegalStateException("Unexpected structure");
            }
            styleRangeBuilder.setProperties(Properties.getEmptyProperties());
            return styleRangeBuilder.build();
        }
        StartElement nextStartElement = ParsingIdioms.peekNextStartElement(this.eventReader);
        if (!ParsingIdioms.PROPERTIES.equals(nextStartElement.getName())) {
            styleRangeBuilder.setProperties(Properties.getEmptyProperties());
            return styleRangeBuilder.build();
        }
        styleRangeBuilder.setProperties(new PropertiesParser(this.eventReader.nextTag().asStartElement(), this.eventReader).parse());
        return styleRangeBuilder.build();
    }
}

