/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertyParserRange;

class PropertiesParser {
    private final StartElement startElement;
    private final XMLEventReader eventReader;

    PropertiesParser(StartElement startElement, XMLEventReader eventReader) {
        this.startElement = startElement;
        this.eventReader = eventReader;
    }

    Properties parse() throws XMLStreamException {
        Properties.PropertiesBuilder propertiesBuilder = new Properties.PropertiesBuilder();
        propertiesBuilder.setStartElement(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                propertiesBuilder.setEndElement(event.asEndElement());
                return propertiesBuilder.build();
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            propertiesBuilder.addProperty(new PropertyParserRange(event.asStartElement(), this.eventReader).parse());
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

