/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=XliffSplitterParameters.class)
public class XliffSplitterParameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final String TRANSLATIONTYPE = "translation_type";
    public static final String TRANSLATIONSTATUS = "translation_status";
    private static final String BIGFILE = "bigFile";
    private static final String FILEMARKER = "fileMarker";
    private static final String UPDATESDLTRANSLATIONSTATUS = "updateSDLTranslationStatus";
    private static final String TRANSLATIONTYPEVALUE = "translationTypeValue";
    private static final String TRANSLATIONSTATUSVALUE = "translationStatusValue";

    @Override
    public void reset() {
        super.reset();
        this.setBigFile(false);
        this.setFileMarker("_PART");
        this.setUpdateSDLTranslationStatus(false);
        this.setTranslationTypeValue("manual_translation");
        this.setTranslationStatusValue("finished");
    }

    public boolean isBigFile() {
        return this.getBoolean(BIGFILE);
    }

    public void setBigFile(boolean bigFile) {
        this.setBoolean(BIGFILE, bigFile);
    }

    public String getFileMarker() {
        return this.getString(FILEMARKER);
    }

    public void setFileMarker(String fileMarker) {
        this.setString(FILEMARKER, fileMarker);
    }

    public boolean isUpdateSDLTranslationStatus() {
        return this.getBoolean(UPDATESDLTRANSLATIONSTATUS);
    }

    public void setUpdateSDLTranslationStatus(boolean updateSDLTranslationStatus) {
        this.setBoolean(UPDATESDLTRANSLATIONSTATUS, updateSDLTranslationStatus);
    }

    public String getTranslationTypeValue() {
        return this.getString(TRANSLATIONTYPEVALUE);
    }

    public void setTranslationTypeValue(String translationTypeValue) {
        this.setString(TRANSLATIONTYPEVALUE, translationTypeValue);
    }

    public String getTranslationStatusValue() {
        return this.getString(TRANSLATIONSTATUSVALUE);
    }

    public void setTranslationStatusValue(String translationStatusValue) {
        this.setString(TRANSLATIONSTATUSVALUE, translationStatusValue);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(BIGFILE, "Process big file", null);
        desc.add(FILEMARKER, "File marker", null);
        desc.add(UPDATESDLTRANSLATIONSTATUS, "Update the <iws:status> translation status (WorldServer-specific)", null);
        desc.add(TRANSLATIONTYPEVALUE, String.format("Value for '%s'", TRANSLATIONTYPE), String.format("Value to set for the %s attribute.", TRANSLATIONTYPE));
        desc.add(TRANSLATIONSTATUSVALUE, String.format("Value for '%s'", TRANSLATIONSTATUS), String.format("Value to set for the %s attribute.", TRANSLATIONSTATUS));
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Splitter", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(BIGFILE));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(FILEMARKER));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramsDesc.get(UPDATESDLTRANSLATIONSTATUS));
        tip = desc.addTextInputPart(paramsDesc.get(TRANSLATIONTYPEVALUE));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        tip = desc.addTextInputPart(paramsDesc.get(TRANSLATIONSTATUSVALUE));
        tip.setVertical(false);
        tip.setMasterPart(cbp, true);
        return desc;
    }
}

