/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.extra.steps.AbstractPipelineStep;
import net.sf.okapi.steps.wordcount.CharacterCounter;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import net.sf.okapi.steps.wordcount.common.Parameters;

@UsingParameters(value=Parameters.class)
public class CharacterCountStep
extends AbstractPipelineStep {
    private Parameters params;
    private IdGenerator gen = new IdGenerator("ending");
    private TextContainer source;
    private StringBuilder sb;
    private CharacterCounter.Counts batchCount = new CharacterCounter.Counts();
    private CharacterCounter.Counts batchItemCount = new CharacterCounter.Counts();
    private CharacterCounter.Counts documentCount = new CharacterCounter.Counts();
    private CharacterCounter.Counts subDocumentCount = new CharacterCounter.Counts();
    private CharacterCounter.Counts groupCount = new CharacterCounter.Counts();

    public CharacterCountStep() {
        this.params = new Parameters();
        this.setParameters(this.params);
        this.setName(this.getName());
        this.setDescription(this.getName());
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        this.batchCount = new CharacterCounter.Counts();
        this.batchItemCount = new CharacterCounter.Counts();
        this.documentCount = new CharacterCounter.Counts();
        this.subDocumentCount = new CharacterCounter.Counts();
        this.groupCount = new CharacterCounter.Counts();
    }

    @Override
    public String getDescription() {
        return "Count the number of characters in the text units of a set of documents or/and in its parts. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Character Count";
    }

    private CharacterCounter.Counts count(TextContainer textContainer, LocaleId locale) {
        return CharacterCounter.fullCount(textContainer, locale);
    }

    private CharacterCounter.Counts count(Segment segment, LocaleId locale) {
        return CharacterCounter.fullCount(segment, locale);
    }

    private CharacterCounter.Counts countInTextUnit(ITextUnit textUnit) {
        if (textUnit == null) {
            return new CharacterCounter.Counts();
        }
        LocaleId srcLocale = this.getSourceLocale();
        TextContainer source = textUnit.getSource();
        CharacterCounter.Counts segCount = new CharacterCounter.Counts();
        CharacterCounter.Counts segmentsCount = new CharacterCounter.Counts();
        CharacterCounter.Counts textContainerCount = new CharacterCounter.Counts();
        ISegments segs = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                segCount = this.count(seg, srcLocale);
                segmentsCount = segmentsCount.add(segCount);
                this.saveToMetrics(seg, segCount);
            }
        }
        textContainerCount = this.count(source, srcLocale);
        this.saveToMetrics(source, textContainerCount);
        if (!textContainerCount.isAllZeros()) {
            return textContainerCount;
        }
        if (!segmentsCount.isAllZeros()) {
            return segmentsCount;
        }
        return new CharacterCounter.Counts();
    }

    protected void saveCount(Metrics metrics, CharacterCounter.Counts count) {
        if (metrics == null || count == null) {
            return;
        }
        metrics.setMetric("TotalCharacterCount", count.total);
        metrics.setMetric("PunctuationCharacterCount", count.punctuation);
        metrics.setMetric("WhiteSpaceCharacterCount", count.whiteSpace);
        metrics.setMetric("OverallCharacterCount", count.total + count.punctuation + count.whiteSpace);
    }

    public CharacterCounter.Counts getBatchCount() {
        return this.batchCount;
    }

    public CharacterCounter.Counts getBatchItemCount() {
        return this.batchItemCount;
    }

    public CharacterCounter.Counts getDocumentCount() {
        return this.documentCount;
    }

    public CharacterCounter.Counts getSubDocumentCount() {
        return this.subDocumentCount;
    }

    public CharacterCounter.Counts getGroupCount() {
        return this.groupCount;
    }

    protected void saveToMetrics(Event event, CharacterCounter.Counts count) {
        Metrics m;
        if (event == null || count == null) {
            return;
        }
        if (count.isAllZeros()) {
            return;
        }
        IWithAnnotations res = (IWithAnnotations)((Object)event.getResource());
        if (res == null) {
            res = (IWithAnnotations)((Object)this.createResource(event));
        }
        if (res == null) {
            return;
        }
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    protected void removeFromMetrics(IWithAnnotations res, String metricName) {
        Metrics m;
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    protected void removeFromMetrics(TextContainer textContainer, String metricName) {
        Metrics m;
        if (textContainer == null) {
            return;
        }
        MetricsAnnotation ma = textContainer.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            textContainer.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    protected void removeFromMetrics(Segment seg, String metricName) {
        Metrics m;
        if (seg == null) {
            return;
        }
        MetricsAnnotation ma = seg.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            seg.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    private IResource createResource(Event event) {
        if (event == null) {
            return null;
        }
        IResource res = event.getResource();
        if (res != null) {
            return res;
        }
        switch (event.getEventType()) {
            case END_BATCH: 
            case END_BATCH_ITEM: 
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: 
            case END_GROUP: {
                res = new Ending(this.gen.createId());
                event.setResource(res);
                break;
            }
        }
        return res;
    }

    protected void saveToMetrics(TextContainer textContainer, CharacterCounter.Counts count) {
        Metrics m;
        if (textContainer == null) {
            return;
        }
        MetricsAnnotation ma = textContainer.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            textContainer.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    protected void saveToMetrics(Segment seg, CharacterCounter.Counts count) {
        Metrics m;
        if (seg == null || count == null) {
            return;
        }
        if (count.isAllZeros()) {
            return;
        }
        MetricsAnnotation ma = seg.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            seg.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.batchCount = new CharacterCounter.Counts();
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.flushBuffer();
        if (!this.params.getCountInBatch()) {
            return event;
        }
        if (this.batchCount.isAllZeros()) {
            return event;
        }
        this.saveToMetrics(event, this.batchCount);
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.batchItemCount = new CharacterCounter.Counts();
        return event;
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        this.flushBuffer();
        if (!this.params.getCountInBatchItems()) {
            return event;
        }
        if (this.batchItemCount.isAllZeros()) {
            return event;
        }
        this.saveToMetrics(event, this.batchItemCount);
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.documentCount = new CharacterCounter.Counts();
        return super.handleStartDocument(event);
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (!this.params.getCountInDocuments()) {
            return event;
        }
        if (this.documentCount.isAllZeros()) {
            return event;
        }
        this.saveToMetrics(event, this.documentCount);
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.subDocumentCount = new CharacterCounter.Counts();
        return event;
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        if (!this.params.getCountInSubDocuments()) {
            return event;
        }
        if (this.subDocumentCount.isAllZeros()) {
            return event;
        }
        this.saveToMetrics(event, this.subDocumentCount);
        return event;
    }

    @Override
    protected Event handleStartGroup(Event event) {
        this.groupCount = new CharacterCounter.Counts();
        return event;
    }

    @Override
    protected Event handleEndGroup(Event event) {
        if (!this.params.getCountInGroups()) {
            return event;
        }
        if (this.groupCount.isAllZeros()) {
            return event;
        }
        this.saveToMetrics(event, this.groupCount);
        return event;
    }

    protected TextContainer getSource() {
        return this.source;
    }

    private void flushBuffer() {
        if (this.params.getBufferSize() == 0) {
            return;
        }
        if (this.sb == null) {
            return;
        }
        TextUnit tu = new TextUnit("temp", this.sb.toString());
        this.sb = null;
        this.updateCounts(tu, null);
    }

    private void updateCounts(ITextUnit tu, Event event) {
        CharacterCounter.Counts textUnitCount = this.countInTextUnit(tu);
        if (!textUnitCount.isAllZeros()) {
            this.saveToMetrics(event, textUnitCount);
            if (this.params.getCountInBatch()) {
                this.batchCount = this.batchCount.add(textUnitCount);
            }
            if (this.params.getCountInBatchItems()) {
                this.batchItemCount = this.batchItemCount.add(textUnitCount);
            }
            if (this.params.getCountInDocuments()) {
                this.documentCount = this.documentCount.add(textUnitCount);
            }
            if (this.params.getCountInSubDocuments()) {
                this.subDocumentCount = this.subDocumentCount.add(textUnitCount);
            }
            if (this.params.getCountInGroups()) {
                this.groupCount = this.groupCount.add(textUnitCount);
            }
        }
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isEmpty()) {
            return event;
        }
        this.source = tu.getSource();
        if (this.params.getBufferSize() > 0) {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.params.getBufferSize());
            }
            String srcText = tu.getSource().getUnSegmentedContentCopy().getText();
            this.sb.append(srcText);
            if (this.sb.length() >= this.params.getBufferSize()) {
                this.flushBuffer();
            }
            return event;
        }
        this.updateCounts(tu, event);
        return event;
    }
}

