/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Map;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleType;

class WordStyleDefinitions
implements StyleDefinitions {
    private RunProperties documentDefaultRunProperties;
    private Map<StyleType, String> defaultStylesByStyleTypes;
    private Map<String, StyleType> styleTypesByStyleIds;
    private Map<String, String> parentStylesByStyleIds;
    private Map<String, String> linkedStylesByStyleIds;
    private Map<String, RunProperties> runPropertiesByStyleIds;

    WordStyleDefinitions(RunProperties documentDefaultRunProperties, Map<StyleType, String> defaultStylesByStyleTypes, Map<String, StyleType> styleTypesByStyleIds, Map<String, String> parentStylesByStyleIds, Map<String, String> linkedStylesByStyleIds, Map<String, RunProperties> runPropertiesByStyleIds) {
        this.documentDefaultRunProperties = documentDefaultRunProperties;
        this.defaultStylesByStyleTypes = defaultStylesByStyleTypes;
        this.styleTypesByStyleIds = styleTypesByStyleIds;
        this.parentStylesByStyleIds = parentStylesByStyleIds;
        this.linkedStylesByStyleIds = linkedStylesByStyleIds;
        this.runPropertiesByStyleIds = runPropertiesByStyleIds;
    }

    @Override
    public RunProperties getCombinedRunProperties(String paragraphStyle, String runStyle, RunProperties runProperties) {
        RunProperties combinedRunProperties = RunProperties.copiedRunProperties(this.documentDefaultRunProperties, false, false, true);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getParagraphStyleProperties(paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(this.getRunStyleProperties(runStyle, paragraphStyle), StyleDefinitions.TraversalStage.VERTICAL);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedToggleRunProperties(this.documentDefaultRunProperties), StyleDefinitions.TraversalStage.DOCUMENT_DEFAULT);
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedRunProperties(runProperties, false, true, false), StyleDefinitions.TraversalStage.DIRECT);
        return combinedRunProperties;
    }

    private RunProperties getParagraphStyleProperties(String paragraphStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.PARAGRAPH, paragraphStyle, null);
    }

    private RunProperties getRunStyleProperties(String runStyle, String linkedStyle) {
        return this.getPropertiesByTypeAndStyle(StyleType.CHARACTER, runStyle, linkedStyle);
    }

    private RunProperties getPropertiesByTypeAndStyle(StyleType styleType, String styleId, String linkedStyleId) {
        if (null == styleId || !this.styleTypesByStyleIds.containsKey(styleId) || !this.styleTypesByStyleIds.get(styleId).equals((Object)styleType)) {
            String defaultStyleId = this.defaultStylesByStyleTypes.get((Object)styleType);
            return this.combineParentStyleProperties(styleType, defaultStyleId, RunProperties.emptyRunProperties());
        }
        return this.combineLinkedAndParentStyleProperties(styleType, styleId, linkedStyleId, RunProperties.emptyRunProperties());
    }

    private RunProperties combineLinkedAndParentStyleProperties(StyleType styleType, String styleId, String linkedStyleId, RunProperties runProperties) {
        if (null == linkedStyleId || StyleType.CHARACTER != styleType || null == this.linkedStylesByStyleIds.get(linkedStyleId) || StyleType.PARAGRAPH != this.styleTypesByStyleIds.get(linkedStyleId)) {
            return this.combineParentStyleProperties(styleType, styleId, runProperties);
        }
        RunProperties paragraphProperties = this.combineParentStyleProperties(StyleType.PARAGRAPH, this.linkedStylesByStyleIds.get(linkedStyleId), RunProperties.emptyRunProperties());
        RunProperties characterProperties = this.combineParentStyleProperties(StyleType.CHARACTER, styleId, RunProperties.emptyRunProperties());
        return paragraphProperties.combineDistinct(characterProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }

    private RunProperties combineParentStyleProperties(StyleType styleType, String styleId, RunProperties runProperties) {
        if (null == this.runPropertiesByStyleIds.get(styleId)) {
            return runProperties;
        }
        if (null == this.parentStylesByStyleIds.get(styleId) || this.styleTypesByStyleIds.get(this.parentStylesByStyleIds.get(styleId)) != styleType) {
            return RunProperties.copiedRunProperties(this.runPropertiesByStyleIds.get(styleId)).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
        }
        return this.combineParentStyleProperties(styleType, this.parentStylesByStyleIds.get(styleId), RunProperties.copiedRunProperties(this.runPropertiesByStyleIds.get(styleId))).combineDistinct(runProperties, StyleDefinitions.TraversalStage.HORIZONTAL);
    }
}

