/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class Run
implements Block.BlockChunk {
    private StartElement startEvent;
    private EndElement endEvent;
    private RunProperties runProperties;
    private RunProperties combinedProperties;
    private List<Chunk> bodyChunks;
    private List<Textual> nestedTextualItems;
    private boolean isHidden;

    Run(StartElement startEvent, EndElement endEvent, RunProperties runProperties, RunProperties combinedProperties, List<Chunk> bodyChunks, List<Textual> nestedTextualItems, boolean isHidden) {
        this.startEvent = startEvent;
        this.endEvent = endEvent;
        this.runProperties = runProperties;
        this.combinedProperties = combinedProperties;
        this.bodyChunks = bodyChunks;
        this.nestedTextualItems = nestedTextualItems;
        this.isHidden = isHidden;
    }

    RunProperties getProperties() {
        return this.runProperties;
    }

    void refineRunProperties(List<RunProperty> runProperties) {
        for (RunProperty runProperty : runProperties) {
            this.runProperties.remove(runProperty);
        }
        if (0 == this.runProperties.count()) {
            this.runProperties = RunProperties.emptyRunProperties();
        }
    }

    RunProperties getCombinedProperties() {
        return this.combinedProperties;
    }

    List<Chunk> getBodyChunks() {
        return this.bodyChunks;
    }

    List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    boolean containsVisibleText() {
        if (this.isHidden) {
            return false;
        }
        for (Chunk c : this.bodyChunks) {
            if (!(c instanceof RunText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startEvent);
        events.addAll(this.runProperties.getEvents());
        for (XMLEvents xMLEvents : this.bodyChunks) {
            events.addAll(xMLEvents.getEvents());
        }
        events.add(this.endEvent);
        return events;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + XMLEventSerializer.serialize(this.getEvents()) + "]";
    }

    static class RunMarkup
    extends Markup
    implements RunChunk {
        RunMarkup() {
        }
    }

    public static interface RunChunk
    extends Chunk {
    }

    static class RunText
    extends Text
    implements RunChunk {
        RunText(StartElement startElement, Characters text, EndElement endElement) {
            super(startElement, text, endElement);
        }
    }
}

