/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class RelationshipsPartHandler
extends GenericPartHandler {
    private static final String RELATIONSHIPS_TAG = "Relationships";
    private static final String RELATIONSHIP_TAG = "Relationship";
    private static final QName RELATIONSHIP_TYPE = new QName("Type");
    private static final QName RELATIONSHIP_TARGET_MODE = new QName("TargetMode");
    private static final QName RELATIONSHIP_TARGET = new QName("Target");
    private final IdGenerator textUnitIdGenerator;
    private final String hyperlinkType;
    private String subDocumentId;
    private XMLEventReader xmlEventReader;
    private Iterator<Event> filterEventIterator;
    private QName relationshipTagName;
    private static final String HYPERLINK = "/hyperlink";
    private static final String TARGET_MODE_EXTERNAL = "External";

    RelationshipsPartHandler(ConditionalParameters params, OpenXMLZipFile zipFile, ZipEntry entry) {
        super(params, zipFile, entry);
        this.textUnitIdGenerator = new IdGenerator(entry.getName(), "tu");
        this.hyperlinkType = zipFile.documentRelationshipsNamespace().uri().concat(HYPERLINK);
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.subDocumentId = subDocumentId;
        this.xmlEventReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        this.handlePart();
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    private void handlePart() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent e = this.xmlEventReader.nextEvent();
            if (e.isStartElement() && e.asStartElement().getName().getLocalPart().equals(RELATIONSHIPS_TAG)) {
                this.qualifyNames(e.asStartElement());
            }
            if (!e.isStartElement() || !e.asStartElement().getName().equals(this.relationshipTagName)) {
                this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.createDocumentPart(e)));
                continue;
            }
            Attribute type = e.asStartElement().getAttributeByName(RELATIONSHIP_TYPE);
            Attribute targetMode = e.asStartElement().getAttributeByName(RELATIONSHIP_TARGET_MODE);
            Attribute target = e.asStartElement().getAttributeByName(RELATIONSHIP_TARGET);
            if (null == type || targetMode == null || target == null || !this.hyperlinkType.equals(type.getValue()) || !TARGET_MODE_EXTERNAL.equals(targetMode.getValue()) || target.getValue().isEmpty()) {
                this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.createDocumentPart(e)));
                continue;
            }
            TextUnit textUnit = this.createTextUnit(e.asStartElement());
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void qualifyNames(StartElement startElement) {
        this.relationshipTagName = new QName(startElement.getName().getNamespaceURI(), RELATIONSHIP_TAG, startElement.getName().getPrefix());
    }

    private DocumentPart createDocumentPart(XMLEvent e) {
        return new DocumentPart(this.documentPartIdGenerator.createId(), false, new GenericSkeleton(XMLEventSerializer.serialize(e)));
    }

    private TextUnit createTextUnit(StartElement startElement) {
        String[] parts = RelationshipsPartHandler.skeletonParts(XMLEventSerializer.serialize(startElement));
        GenericSkeleton skel = new GenericSkeleton();
        skel.append(parts[0]);
        TextUnit textUnit = new TextUnit(this.textUnitIdGenerator.createId());
        textUnit.setSourceContent(new TextFragment(parts[1]));
        skel.addContentPlaceholder(textUnit);
        skel.append(parts[2]);
        textUnit.setSkeleton(skel);
        return textUnit;
    }

    private static String[] skeletonParts(String string) {
        String startValueMarker = RELATIONSHIP_TARGET.getPrefix().isEmpty() ? RELATIONSHIP_TARGET.getLocalPart() + "=\"" : RELATIONSHIP_TARGET.getPrefix() + ":" + RELATIONSHIP_TARGET.getLocalPart() + "=\"";
        int valueIndex = string.indexOf(startValueMarker) + startValueMarker.length();
        int lastPartIndex = string.indexOf("\"", valueIndex);
        return new String[]{string.substring(0, valueIndex), string.substring(valueIndex, lastPartIndex), string.substring(lastPartIndex, string.length())};
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

