/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;

abstract class GenericPartHandler
implements OpenXMLPartHandler {
    protected final ConditionalParameters params;
    protected final OpenXMLZipFile zipFile;
    protected final ZipEntry entry;
    protected final List<Event> filterEvents;
    protected final IdGenerator documentPartIdGenerator;
    protected List<XMLEvent> documentPartEvents;

    GenericPartHandler(ConditionalParameters params, OpenXMLZipFile zipFile, ZipEntry entry) {
        this.params = params;
        this.zipFile = zipFile;
        this.entry = entry;
        this.filterEvents = new ArrayList<Event>();
        this.documentPartIdGenerator = new IdGenerator(entry.getName(), "dp");
        this.documentPartEvents = new ArrayList<XMLEvent>();
    }

    protected Event createStartSubDocumentEvent(String documentId, String subDocumentId) {
        StartSubDocument sd = new StartSubDocument(documentId, subDocumentId);
        sd.setName(this.entry.getName());
        if (this.zipFile != null) {
            ZipSkeleton zs = new ZipSkeleton(this.zipFile.getZip(), this.entry);
            sd.setSkeleton(zs);
        }
        sd.setFilterId("okf_openxml");
        ConditionalParameters clonedParams = this.params.clone();
        sd.setFilterParameters(clonedParams);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    protected void addEventToDocumentPart(XMLEvent e) {
        this.documentPartEvents.add(e);
    }
}

