/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEvents;

class Block
implements XMLEvents,
Textual {
    private final List<Chunk> chunks;
    private final QName runName;
    private final QName textName;
    private final boolean hidden;
    private final boolean skipped;
    private final Collection<XMLEvent> deferredEvents;

    Block(List<Chunk> chunks, QName runName, QName textName, boolean hidden, boolean skipped, Collection<XMLEvent> deferredEvents) {
        this.chunks = chunks;
        this.runName = runName;
        this.textName = textName;
        this.hidden = hidden;
        this.skipped = skipped;
        this.deferredEvents = deferredEvents;
    }

    QName getRunName() {
        return this.runName;
    }

    QName getTextName() {
        return this.textName;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (XMLEvents xMLEvents : this.chunks) {
            events.addAll(xMLEvents.getEvents());
        }
        return events;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    boolean isHidden() {
        return this.hidden;
    }

    boolean isSkipped() {
        return this.skipped;
    }

    boolean hasVisibleRunContent() {
        for (Chunk chunk : this.chunks) {
            if (!(chunk instanceof Run ? ((Run)chunk).containsVisibleText() : chunk instanceof RunContainer && ((RunContainer)chunk).containsVisibleText())) continue;
            return true;
        }
        return false;
    }

    Collection<XMLEvent> deferredEvents() {
        return this.deferredEvents;
    }

    public String toString() {
        return "Block [" + this.chunks + "]";
    }

    static class Builder
    implements ChunkContainer {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private List<XMLEvent> currentMarkupComponentEvents = new ArrayList<XMLEvent>();
        private Collection<XMLEvent> deferredEvents = new LinkedList<XMLEvent>();
        private Markup markup = new BlockMarkup();
        private boolean hidden = false;
        private boolean skipped = false;
        private QName runName;
        private QName textName;

        Builder() {
        }

        boolean isHidden() {
            return this.hidden;
        }

        void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        void setRunName(QName runName) {
            if (this.runName == null) {
                this.runName = runName;
            }
        }

        void setTextName(QName textName) {
            if (this.textName == null) {
                this.textName = textName;
            }
        }

        void flushMarkup() {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            if (!this.markup.getComponents().isEmpty()) {
                this.chunks.add(this.markup);
                this.markup = new BlockMarkup();
            }
        }

        void addEvent(XMLEvent event) {
            this.currentMarkupComponentEvents.add(event);
        }

        @Override
        public void addChunk(BlockChunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            this.markup.addComponent(markupComponent);
        }

        void addDeferredEvents(Collection<XMLEvent> deferredEvents) {
            this.deferredEvents.addAll(deferredEvents);
        }

        Block buildWith(StyleOptimisation styleOptimisation) throws XMLStreamException {
            this.flushMarkup();
            return new Block(styleOptimisation.applyTo(this.chunks), this.runName, this.textName, this.hidden, this.skipped, this.deferredEvents);
        }
    }

    static class BlockMarkup
    extends Markup
    implements BlockChunk {
        private static final String START_MARKUP_COMPONENT_IS_NOT_FOUND = "Unexpected structure: the start markup component is not found";

        BlockMarkup() {
        }

        BlockProperties blockProperties() {
            for (MarkupComponent markupComponent : this.getComponents()) {
                if (!(markupComponent instanceof BlockProperties)) continue;
                return (BlockProperties)markupComponent;
            }
            return null;
        }

        void updateOrAddComponent(BlockProperties blockProperties) {
            ListIterator<MarkupComponent> componentsIterator = this.getComponents().listIterator();
            while (componentsIterator.hasNext()) {
                MarkupComponent markupComponent = componentsIterator.next();
                if (!(markupComponent instanceof BlockProperties)) continue;
                componentsIterator.set(blockProperties);
                return;
            }
            BlockMarkup.rewindAfterStartMarkupComponent(componentsIterator);
            componentsIterator.add(blockProperties);
        }

        private static void rewindAfterStartMarkupComponent(ListIterator<MarkupComponent> iterator) {
            while (iterator.hasPrevious()) {
                if (!(iterator.previous() instanceof MarkupComponent.StartMarkupComponent)) continue;
                iterator.next();
                return;
            }
            throw new IllegalStateException(START_MARKUP_COMPONENT_IS_NOT_FOUND);
        }
    }

    public static interface BlockChunk
    extends Chunk {
    }
}

