/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String EXTRACTBODYPAGES = "extractBodyPages";
    private static final String EXTRACTREFERENCEPAGES = "extractReferencePages";
    private static final String EXTRACTMASTERPAGES = "extractMasterPages";
    private static final String EXTRACTHIDDENPAGES = "extractHiddenPages";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String EXTRACTVARIABLES = "extractVariables";
    private static final String EXTRACTINDEXMARKERS = "extractIndexMarkers";
    private static final String EXTRACTLINKS = "extractLinks";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean getExtractReferencePages() {
        return this.getBoolean(EXTRACTREFERENCEPAGES);
    }

    public void setExtractReferencePages(boolean extractReferencePages) {
        this.setBoolean(EXTRACTREFERENCEPAGES, extractReferencePages);
    }

    public boolean getExtractMasterPages() {
        return this.getBoolean(EXTRACTMASTERPAGES);
    }

    public void setExtractMasterPages(boolean extractMasterPages) {
        this.setBoolean(EXTRACTMASTERPAGES, extractMasterPages);
    }

    public boolean getExtractHiddenPages() {
        return this.getBoolean(EXTRACTHIDDENPAGES);
    }

    public void setExtractHiddenPages(boolean extractHiddenPages) {
        this.setBoolean(EXTRACTHIDDENPAGES, extractHiddenPages);
    }

    public boolean getExtractBodyPages() {
        return this.getBoolean(EXTRACTBODYPAGES);
    }

    public void setExtractBodyPages(boolean extractBodyPages) {
        this.setBoolean(EXTRACTBODYPAGES, extractBodyPages);
    }

    public boolean getExtractVariables() {
        return this.getBoolean(EXTRACTVARIABLES);
    }

    public void setExtractVariables(boolean extractVariables) {
        this.setBoolean(EXTRACTVARIABLES, extractVariables);
    }

    public boolean getExtractIndexMarkers() {
        return this.getBoolean(EXTRACTINDEXMARKERS);
    }

    public void setExtractIndexMarkers(boolean extractIndexMarkers) {
        this.setBoolean(EXTRACTINDEXMARKERS, extractIndexMarkers);
    }

    public boolean getExtractLinks() {
        return this.getBoolean(EXTRACTLINKS);
    }

    public void setExtractLinks(boolean extractLinks) {
        this.setBoolean(EXTRACTLINKS, extractLinks);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setExtractBodyPages(true);
        this.setExtractMasterPages(true);
        this.setExtractReferencePages(true);
        this.setExtractHiddenPages(true);
        this.setExtractVariables(true);
        this.setExtractIndexMarkers(true);
        this.setExtractLinks(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("text <$varName> text");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("<\\$.*?>");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

