/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ReferenceableEvent;
import net.sf.okapi.filters.idml.ReferenceableEventsWriter;

class SubDocumentWriter
implements IFilterWriter {
    private static String ERROR_CREATING_SUB_DOCUMENT_WRITER = "Error creating sub document writer";
    private static String ERROR_ADDING_EVENTS_TO_SUB_DOCUMENT_WRITER = "Error adding events to sub document writer";
    private static String ERROR_CLOSING_SUB_DOCUMENT_WRITER = "Error closing sub document writer";
    private final Parameters parameters;
    private final ReferenceableEventsWriter referenceableEventsWriter;
    private final XMLEventWriter writer;
    private final List<ReferenceableEvent> referenceableEvents;
    private final Deque<ReferenceableEvent> parentReferenceableEvents;

    SubDocumentWriter(Parameters parameters, XMLOutputFactory outputFactory, Charset charset, String outputPath, ReferenceableEventsWriter referenceableEventsWriter) {
        this.parameters = parameters;
        this.referenceableEventsWriter = referenceableEventsWriter;
        this.writer = this.getWriter(outputPath, charset, outputFactory);
        this.referenceableEvents = new ArrayList<ReferenceableEvent>();
        this.parentReferenceableEvents = new ArrayDeque<ReferenceableEvent>();
    }

    private XMLEventWriter getWriter(String outputPath, Charset charset, XMLOutputFactory outputFactory) {
        Util.createDirectories(outputPath);
        try {
            return outputFactory.createXMLEventWriter(new FileOutputStream(outputPath), charset.name());
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new OkapiIOException(ERROR_CREATING_SUB_DOCUMENT_WRITER, e);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
    }

    @Override
    public void setOutput(String path) {
    }

    @Override
    public void setOutput(OutputStream output) {
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_GROUP: {
                this.handleStartGroupEvent(event);
                break;
            }
            case END_GROUP: {
                this.handleEndGroupEvent();
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnitEvent(event);
                break;
            }
            case DOCUMENT_PART: {
                this.handleDocumentPartEvent(event);
                break;
            }
            case END_DOCUMENT: {
                this.handleEndDocumentEvent(event);
                this.close();
                break;
            }
        }
        return event;
    }

    private void handleStartGroupEvent(Event event) {
        ReferenceableEvent parentReferenceableEvent = this.findParentReferenceableEvent(event.getStartGroup().getParentId());
        ReferenceableEvent referentEvent = new ReferenceableEvent(event.getStartGroup().getId(), event);
        parentReferenceableEvent.addReferentEvent(referentEvent);
        this.parentReferenceableEvents.push(referentEvent);
    }

    private ReferenceableEvent findParentReferenceableEvent(String parentId) {
        if (!this.parentReferenceableEvents.isEmpty()) {
            return this.parentReferenceableEvents.peek();
        }
        ReferenceableEvent referenceableEvent = this.findReferenceableEvent(this.referenceableEvents, parentId);
        if (null == referenceableEvent) {
            throw new IllegalStateException("Unexpected structure");
        }
        return referenceableEvent;
    }

    private ReferenceableEvent findReferenceableEvent(List<ReferenceableEvent> referenceableEvents, String eventId) {
        for (ReferenceableEvent referenceableEvent : referenceableEvents) {
            ReferenceableEvent foundReferenceableEvent;
            if (referenceableEvent.getEventId().equals(eventId)) {
                return referenceableEvent;
            }
            if (referenceableEvent.getReferentEvents().isEmpty() || null == (foundReferenceableEvent = this.findReferenceableEvent(referenceableEvent.getReferentEvents(), eventId))) continue;
            return foundReferenceableEvent;
        }
        return null;
    }

    private void handleEndGroupEvent() {
        this.parentReferenceableEvents.pop();
    }

    private void handleTextUnitEvent(Event event) {
        ReferenceableEvent referenceableEvent = new ReferenceableEvent(event.getTextUnit().getId(), event);
        this.addReferenceableEvent(referenceableEvent);
    }

    private void handleDocumentPartEvent(Event event) {
        ReferenceableEvent referenceableEvent = new ReferenceableEvent(event.getDocumentPart().getId(), event);
        this.addReferenceableEvent(referenceableEvent);
    }

    private void addReferenceableEvent(ReferenceableEvent referenceableEvent) {
        if (!this.parentReferenceableEvents.isEmpty()) {
            ReferenceableEvent parentReferenceableEvent = this.parentReferenceableEvents.peek();
            parentReferenceableEvent.addReferentEvent(referenceableEvent);
        } else {
            this.referenceableEvents.add(referenceableEvent);
        }
    }

    private void handleEndDocumentEvent(Event event) {
        try {
            this.addEvents(this.referenceableEventsWriter.write(this.referenceableEvents));
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(ERROR_ADDING_EVENTS_TO_SUB_DOCUMENT_WRITER, e);
        }
    }

    private void addEvents(List<XMLEvent> events) throws XMLStreamException {
        for (XMLEvent event : events) {
            this.writer.add(event);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(ERROR_CLOSING_SUB_DOCUMENT_WRITER, e);
        }
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

