/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.SpreadItem;
import net.sf.okapi.filters.idml.SpreadItemHolder;

class State {
    private final String id;
    private final boolean active;
    private final List<SpreadItem> spreadItems;

    State(String id, boolean active, List<SpreadItem> spreadItems) {
        this.id = id;
        this.active = active;
        this.spreadItems = spreadItems;
    }

    String getId() {
        return this.id;
    }

    boolean isActive() {
        return this.active;
    }

    List<SpreadItem> getSpreadItems() {
        return this.spreadItems;
    }

    static class StateBuilder
    implements Builder<State>,
    SpreadItemHolder {
        private String id;
        private boolean active;
        private String activeLayerId;
        private List<SpreadItem> spreadItems = new ArrayList<SpreadItem>();

        StateBuilder() {
        }

        StateBuilder setId(String id) {
            this.id = id;
            return this;
        }

        StateBuilder setActive(boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public String getActiveLayerId() {
            return this.activeLayerId;
        }

        StateBuilder setActiveLayerId(String activeLayerId) {
            this.activeLayerId = activeLayerId;
            return this;
        }

        @Override
        public StateBuilder addSpreadItem(SpreadItem spreadItem) {
            this.spreadItems.add(spreadItem);
            return this;
        }

        @Override
        public State build() {
            return new State(this.id, this.active, this.spreadItems);
        }
    }
}

