/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.ReferenceableEvent;
import net.sf.okapi.filters.idml.ReferenceableEventsMerger;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.StyledTextSkeleton;

class ReferenceableEventsWriter {
    private final ReferenceableEventsMerger referenceableEventMerger;
    private final StyleRangeEventsGenerator styleRangeEventsGenerator;
    private StoryChildElementsWriter storyChildElementsWriter;
    private List<XMLEvent> events;

    ReferenceableEventsWriter(ReferenceableEventsMerger referenceableEventMerger, StyleRangeEventsGenerator styleRangeEventsGenerator) {
        this.referenceableEventMerger = referenceableEventMerger;
        this.styleRangeEventsGenerator = styleRangeEventsGenerator;
    }

    List<XMLEvent> write(List<ReferenceableEvent> referenceableEvents) {
        this.events = new ArrayList<XMLEvent>();
        this.storyChildElementsWriter = new StoryChildElementsWriter(this.styleRangeEventsGenerator);
        ReferenceableEvent lastStyledReferenceableEvent = this.getLastStyledReferenceableEvent(referenceableEvents);
        for (ReferenceableEvent referenceableEvent : referenceableEvents) {
            this.writeReferenceableEvent(referenceableEvent);
            if (referenceableEvent != lastStyledReferenceableEvent) continue;
            this.events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
            this.events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
        }
        return this.events;
    }

    private ReferenceableEvent getLastStyledReferenceableEvent(List<ReferenceableEvent> referenceableEvents) {
        ListIterator<ReferenceableEvent> listIterator = referenceableEvents.listIterator(referenceableEvents.size());
        while (listIterator.hasPrevious()) {
            ReferenceableEvent referenceableEvent = listIterator.previous();
            if (!this.isStyledReferenceableEvent(referenceableEvent)) continue;
            return referenceableEvent;
        }
        return null;
    }

    private boolean isStyledReferenceableEvent(ReferenceableEvent referenceableEvent) {
        switch (referenceableEvent.getEvent().getEventType()) {
            case TEXT_UNIT: {
                return true;
            }
            case DOCUMENT_PART: {
                return referenceableEvent.getEvent().getDocumentPart().getSkeleton() instanceof StyledTextSkeleton;
            }
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private void writeReferenceableEvent(ReferenceableEvent referenceableEvent) {
        switch (referenceableEvent.getEvent().getEventType()) {
            case TEXT_UNIT: {
                this.writeTextUnitReferenceableEvent(referenceableEvent);
                break;
            }
            case DOCUMENT_PART: {
                this.writeDocumentPartReferenceableEvent(referenceableEvent);
            }
        }
    }

    private void writeTextUnitReferenceableEvent(ReferenceableEvent referenceableEvent) {
        this.referenceableEventMerger.merge(referenceableEvent);
        StyledTextSkeleton skeleton = (StyledTextSkeleton)referenceableEvent.getEvent().getTextUnit().getSkeleton();
        this.events.addAll(this.storyChildElementsWriter.write(skeleton.getStoryChildElements()));
    }

    private void writeDocumentPartReferenceableEvent(ReferenceableEvent referenceableEvent) {
        ISkeleton skeleton = referenceableEvent.getEvent().getDocumentPart().getSkeleton();
        if (skeleton instanceof MarkupSkeleton) {
            Markup markup = ((MarkupSkeleton)skeleton).getMarkup();
            this.events.addAll(markup.getEvents());
            return;
        }
        if (skeleton instanceof StyledTextSkeleton) {
            this.events.addAll(this.storyChildElementsWriter.write(((StyledTextSkeleton)skeleton).getStoryChildElements()));
            return;
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

