/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.ReferenceableEvent;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyledTextReferenceSkeleton;
import net.sf.okapi.filters.idml.StyledTextSkeleton;

class ReferenceableEventsMerger {
    private static final String UNEXPECTED_CODE = "Unexpected code";
    private static final QName CONTENT_SPACE_ATTRIBUTE_NAME = Namespaces.getXmlNamespace().getQName("space");
    private static final String CONTENT_SPACE_ATTRIBUTE_VALUE = "preserve";
    private final XMLEventFactory eventFactory;
    private final LocaleId targetLocale;
    private final StyleDefinitions defaultStyleDefinitions;
    private List<StoryChildElement> storyChildElements;
    private Map<Integer, Object> codeMap;
    private Deque<List<StoryChildElement>> savedStoryChildElements;
    private StoryChildElement savedBreak;
    private Deque<StyleDefinitions> currentStyleDefinitions;
    private StringBuilder contentTextBuilder;
    private List<XMLEvent> contentEvents;

    ReferenceableEventsMerger(XMLEventFactory eventFactory, LocaleId targetLocale) {
        this.eventFactory = eventFactory;
        this.targetLocale = targetLocale;
        this.defaultStyleDefinitions = StyleDefinitions.getDefaultStyleDefinitions(eventFactory);
    }

    void merge(ReferenceableEvent referenceableEvent) {
        for (ReferenceableEvent referentEvent : referenceableEvent.getReferentEvents()) {
            new ReferenceableEventsMerger(this.eventFactory, this.targetLocale).merge(referentEvent);
        }
        if (referenceableEvent.getEvent().isStartGroup()) {
            this.mergeStartGroup(referenceableEvent);
            return;
        }
        if (referenceableEvent.getEvent().isDocumentPart()) {
            return;
        }
        this.mergeTextUnit(referenceableEvent);
    }

    private void mergeStartGroup(ReferenceableEvent referenceableEvent) {
        StyledTextReferenceSkeleton styledTextReferenceSkeleton = (StyledTextReferenceSkeleton)referenceableEvent.getEvent().getStartGroup().getSkeleton();
        StoryChildElement.StyledTextReferenceElement styledTextReferenceElement = styledTextReferenceSkeleton.getStyledTextReferenceElement();
        if (styledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Table) {
            return;
        }
        this.storyChildElements = styledTextReferenceElement.getStoryChildElements();
        this.storyChildElements.clear();
        for (ReferenceableEvent referentEvent : referenceableEvent.getReferentEvents()) {
            if (referentEvent.getEvent().isStartGroup()) {
                StoryChildElement.StyledTextReferenceElement nestedStyledTextReferenceElement = ((StyledTextReferenceSkeleton)referenceableEvent.getEvent().getStartGroup().getSkeleton()).getStyledTextReferenceElement();
                if (!(nestedStyledTextReferenceElement instanceof StoryChildElement.StyledTextReferenceElement.Table)) continue;
                this.storyChildElements.add(nestedStyledTextReferenceElement);
            }
            if (referentEvent.getEvent().isDocumentPart()) {
                ISkeleton skeleton = referentEvent.getEvent().getDocumentPart().getSkeleton();
                if (skeleton instanceof MarkupSkeleton) {
                    this.addStoryChildElementsFromMarkupSkeleton((MarkupSkeleton)skeleton);
                    continue;
                }
                if (skeleton instanceof StyledTextSkeleton) {
                    this.addStoryChildElementsFromStyledTextSkeleton((StyledTextSkeleton)skeleton);
                    continue;
                }
                throw new IllegalStateException("Unexpected structure");
            }
            this.addStoryChildElementsFromStyledTextSkeleton((StyledTextSkeleton)referentEvent.getEvent().getTextUnit().getSkeleton());
        }
    }

    private void addStoryChildElementsFromMarkupSkeleton(MarkupSkeleton markupSkeleton) {
        for (MarkupRange markupRange : markupSkeleton.getMarkup().getMarkupRanges()) {
            if (!(markupRange instanceof StoryChildElement)) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.storyChildElements.add((StoryChildElement)markupRange);
        }
    }

    private void addStoryChildElementsFromStyledTextSkeleton(StyledTextSkeleton styledTextSkeleton) {
        this.storyChildElements.addAll(styledTextSkeleton.getStoryChildElements());
    }

    private void mergeTextUnit(ReferenceableEvent referenceableEvent) {
        ITextUnit textUnit = referenceableEvent.getEvent().getTextUnit();
        StyledTextSkeleton styledTextSkeleton = (StyledTextSkeleton)textUnit.getSkeleton();
        this.storyChildElements = styledTextSkeleton.getStoryChildElements();
        this.codeMap = styledTextSkeleton.getCodeMap();
        this.savedStoryChildElements = new ArrayDeque<List<StoryChildElement>>();
        this.savedBreak = this.saveBreak(this.storyChildElements);
        this.storyChildElements.clear();
        this.currentStyleDefinitions = new ArrayDeque<StyleDefinitions>();
        this.contentTextBuilder = new StringBuilder();
        this.contentEvents = new ArrayList<XMLEvent>();
        this.mergeTextContainer(null == textUnit.getTarget(this.targetLocale) ? textUnit.getSource() : textUnit.getTarget(this.targetLocale));
    }

    private StoryChildElement saveBreak(List<StoryChildElement> textUnitElements) {
        for (StoryChildElement storyChildElement : textUnitElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement.Break)) continue;
            return storyChildElement;
        }
        return null;
    }

    private void mergeTextContainer(TextContainer textContainer) {
        for (Segment segment : textContainer.getSegments()) {
            this.mergeSegment(segment);
        }
        this.addContent();
        this.addBreak();
    }

    private void mergeSegment(Segment segment) {
        TextFragment textFragment = segment.getContent();
        String codedText = textFragment.getCodedText();
        List<Code> codes = textFragment.getCodes();
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (!TextFragment.isMarker(c)) {
                this.addChar(c);
                continue;
            }
            int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
            this.addCode(codes.get(codeIndex));
        }
    }

    private void addChar(char c) {
        this.contentTextBuilder.append(c);
    }

    private void addCode(Code code) {
        Object codeObject = this.codeMap.get(code.getId());
        switch (code.getTagType()) {
            case OPENING: {
                this.addContent();
                if (codeObject instanceof StyleDefinitions) {
                    this.currentStyleDefinitions.push((StyleDefinitions)codeObject);
                    break;
                }
                if (codeObject instanceof StoryChildElement.StyledTextReferenceElement) {
                    this.currentStyleDefinitions.push(((StoryChildElement.StyledTextReferenceElement)codeObject).getStyleDefinitions());
                    this.storyChildElements.add((StoryChildElement.StyledTextReferenceElement)codeObject);
                    this.savedStoryChildElements.push(this.storyChildElements);
                    this.storyChildElements = ((StoryChildElement.StyledTextReferenceElement)codeObject).getStoryChildElements();
                    this.storyChildElements.clear();
                    break;
                }
                throw new IllegalStateException(UNEXPECTED_CODE + codeObject);
            }
            case PLACEHOLDER: {
                if (codeObject instanceof SpecialCharacter) {
                    this.addSpecialCharacter((SpecialCharacter)codeObject);
                    break;
                }
                if (codeObject instanceof StoryChildElement) {
                    this.addStoryChildElement((StoryChildElement)codeObject);
                    break;
                }
                throw new IllegalStateException(UNEXPECTED_CODE + codeObject);
            }
            case CLOSING: {
                this.addContent();
                if (codeObject instanceof StyleDefinitions) {
                    this.currentStyleDefinitions.pop();
                    break;
                }
                if (codeObject instanceof StoryChildElement.StyledTextReferenceElement) {
                    this.currentStyleDefinitions.pop();
                    this.storyChildElements = this.savedStoryChildElements.pop();
                    break;
                }
                throw new IllegalStateException(UNEXPECTED_CODE + codeObject);
            }
        }
    }

    private void addSpecialCharacter(SpecialCharacter specialCharacter) {
        if (!(specialCharacter instanceof SpecialCharacter.Instruction)) {
            this.contentTextBuilder.append(specialCharacter.getEvent().asCharacters().getData());
            return;
        }
        if (0 < this.contentTextBuilder.length()) {
            this.contentEvents.add(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
            this.contentTextBuilder = new StringBuilder();
        }
        this.contentEvents.addAll(specialCharacter.getEvents());
    }

    private void addStoryChildElement(StoryChildElement storyChildElement) {
        this.addContent();
        this.storyChildElements.add(storyChildElement);
    }

    private void addContent() {
        if (0 == this.contentEvents.size() && 0 == this.contentTextBuilder.length()) {
            return;
        }
        ArrayList<Attribute> contentAttributes = new ArrayList<Attribute>();
        contentAttributes.add(this.eventFactory.createAttribute(CONTENT_SPACE_ATTRIBUTE_NAME, CONTENT_SPACE_ATTRIBUTE_VALUE));
        StoryChildElement.StyledTextElement.Content.ContentBuilder contentBuilder = new StoryChildElement.StyledTextElement.Content.ContentBuilder();
        contentBuilder.setStartElement(this.eventFactory.createStartElement(ParsingIdioms.StyledStoryChildElement.CONTENT.getName(), contentAttributes.iterator(), null));
        if (0 < this.contentEvents.size()) {
            for (XMLEvent event : this.contentEvents) {
                contentBuilder.addInnerEvent(event);
            }
            this.contentEvents = new ArrayList<XMLEvent>();
        }
        if (0 < this.contentTextBuilder.length()) {
            contentBuilder.addInnerEvent(this.eventFactory.createCharacters(this.contentTextBuilder.toString()));
            this.contentTextBuilder = new StringBuilder();
        }
        contentBuilder.setEndElement(this.eventFactory.createEndElement(ParsingIdioms.StyledStoryChildElement.CONTENT.getName(), null));
        contentBuilder.setStyleDefinitions(this.getStyleDefinitions());
        this.storyChildElements.add(contentBuilder.build());
    }

    private void addBreak() {
        if (null == this.savedBreak) {
            return;
        }
        this.storyChildElements.add(this.savedBreak);
    }

    private StyleDefinitions getStyleDefinitions() {
        StyleDefinitions styleDefinitions = this.currentStyleDefinitions.peek();
        if (null == styleDefinitions) {
            return this.defaultStyleDefinitions;
        }
        return styleDefinitions;
    }
}

