/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.SubDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NonTranslatableSubDocument
implements SubDocument {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;
    private final String id;

    NonTranslatableSubDocument(ZipFile zipFile, ZipEntry zipEntry, String parentId, String id) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.id = id;
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        DocumentPart documentPart = new DocumentPart(this.zipEntry.getName(), false);
        ZipSkeleton skeleton = new ZipSkeleton(this.zipFile, this.zipEntry);
        skeleton.setModifiedContents(this.getModifiedContent());
        return new Event(EventType.DOCUMENT_PART, documentPart, skeleton);
    }

    protected String getModifiedContent() {
        return null;
    }

    @Override
    public boolean hasNextEvent() {
        return false;
    }

    @Override
    public Event nextEvent() {
        throw new IllegalStateException();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
        this.logger.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.zipEntry.getName());
    }
}

