/* YamlParser.java */
/* Generated By:JavaCC: Do not edit this line. YamlParser.java */
package net.sf.okapi.filters.yaml.parser;
import java.util.List;

/**
//* Basic YAML parser.
*/
public class YamlParser implements YamlParserConstants {
  private IYamlHandler handler = null;

  public void setHandler(IYamlHandler handler)
  {
    this.handler = handler;
  }

  public void reset() {
         token_source.reset();
  }

  public void parse() throws ParseException
  {
    token_source.initialize(handler);
    handler.handleStart();
    yaml_stream();
    handler.handleEnd();
  }

        public String ignorableTextBefore(Token t, boolean firstTime) {
                StringBuilder s = new StringBuilder();
                List<Token> specialTokenList = token_source.getSpecialTokensBefore(t);
            if (specialTokenList != null) {
              for (Token st : specialTokenList) {
                if (firstTime) {
                        switch(st.kind) {
                                case COMMENT_TEXT:
                                        handler.handleComment(st.image, true);
                                break;
                                case EOL:
                                case SPACE:
                                        handler.handleWhitespace(st.image, true);
                                break;
                                default:
                                        handler.handleOther(t.image);
                                break;
                        }
                } else {
                        s.append(st.image);
                }
              }
            }
            return s.toString();
        }

//# A YAML Stream is the top level rule, and accounts for the entirety of the
//# text being parsed. Basically, a stream is a set of zero or more documents,
//# but there can be ignorable comments on either side of an explicitly marked
//# document. NOTE: Not yet dealing with directives.
  final public void yaml_stream() throws ParseException {Token v = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VERSION_TAG:{
      v = jj_consume_token(VERSION_TAG);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
handler.handleOther(v!=null ? v.image : null);
    label_1:
    while (true) {
      yaml_document();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BLOCK_SEQUENCE_START:
      case BLOCK_MAPPING_START:
      case FALSE_START:
      case TAG:
      case TAG_DIRECTIVE:
      case ANCHOR:
      case ALIAS:
      case FLOW_SEQUENCE_START:
      case FLOW_MAPPING_START:
      case DOCUMENT_START:
      case SINGLE_QUOTED_EMPTY:
      case DOUBLE_QUOTED_EMPTY:
      case SINGLE_QUOTED_FIRST:
      case DOUBLE_QUOTED_FIRST:
      case LITERAL_SCALAR_START:
      case FOLDED_SCALAR_START:
      case PLAIN_SCALAR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
    }
}

//# A YAML Document is a single node of any kind. It may start with an optional
//# explicit head marker, and may be terminated with an optional explicit foot
//# marker.
  final public void yaml_document() throws ParseException {Token t = null;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FALSE_START:
      case DOCUMENT_START:{
        document_start();
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        ;
      }
      label_3:
      while (true) {
        node();
        if (jj_2_1(2)) {
          ;
        } else {
          break label_3;
        }
      }
      if (jj_2_2(2)) {
        document_end();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BLOCK_SEQUENCE_START:
      case BLOCK_MAPPING_START:
      case FALSE_START:
      case TAG:
      case TAG_DIRECTIVE:
      case ANCHOR:
      case ALIAS:
      case FLOW_SEQUENCE_START:
      case FLOW_MAPPING_START:
      case DOCUMENT_START:
      case SINGLE_QUOTED_EMPTY:
      case DOUBLE_QUOTED_EMPTY:
      case SINGLE_QUOTED_FIRST:
      case DOUBLE_QUOTED_FIRST:
      case LITERAL_SCALAR_START:
      case FOLDED_SCALAR_START:
      case PLAIN_SCALAR:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
    }
    jj_consume_token(0);
}

  final public void document_start() throws ParseException {Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE_START:{
      jj_consume_token(FALSE_START);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    t = jj_consume_token(DOCUMENT_START);
reset(); handler.handleDocumentStart(t.image);
}

  final public void document_end() throws ParseException {Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE_START:{
      jj_consume_token(FALSE_START);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    t = jj_consume_token(DOCUMENT_END);
reset(); handler.handleDocumentEnd(t.image);
}

  final public void node() throws ParseException {Token t;
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TAG:
      case ANCHOR:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      anchor_or_tag();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLOCK_SEQUENCE_START:
    case FLOW_SEQUENCE_START:{
      sequence();
      break;
      }
    case BLOCK_MAPPING_START:
    case FLOW_MAPPING_START:{
      mapping();
      break;
      }
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:
    case LITERAL_SCALAR_START:
    case FOLDED_SCALAR_START:
    case PLAIN_SCALAR:{
      scalar();
      break;
      }
    case ALIAS:{
      t = jj_consume_token(ALIAS);
handler.handleOther(t.image);
      break;
      }
    case TAG_DIRECTIVE:{
      t = jj_consume_token(TAG_DIRECTIVE);
handler.handleOther(t.image);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void anchor_or_tag() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ANCHOR:{
      t = jj_consume_token(ANCHOR);
      break;
      }
    case TAG:{
      t = jj_consume_token(TAG);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
handler.handleOther(t.image);
}

  final public void scalar() throws ParseException {Scalar s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:{
      s = quoted_string();
      break;
      }
    case LITERAL_SCALAR_START:{
      s = literal_style();
      break;
      }
    case FOLDED_SCALAR_START:{
      s = folded_style();
      break;
      }
    case PLAIN_SCALAR:{
      s = plain_scalar();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
handler.handleScalar(s); token_source.processIndentedBlockEnd();
}

  final public void flow_scalar() throws ParseException {Scalar s = null; Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:{
      s = quoted_string();
      break;
      }
    case PLAIN_FLOW_SCALAR:{
      t = jj_consume_token(PLAIN_FLOW_SCALAR);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (s != null) {
                s.flow = true;
                { handler.handleScalar(s);}
        } else if (t != null) {
                Scalar ts = new Scalar();
                ts.flow = true;
                ts.type = YamlScalarTypes.PLAIN;
                ts.scalar = t.image;
                { handler.handleScalar(ts); }
        }
}

  final public Scalar quoted_string() throws ParseException {QuotedScalar q;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_FIRST:{
      q = double_quoted_string();
      break;
      }
    case SINGLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:{
      q = single_quoted_string();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Scalar s = new Scalar();
        s.type = q.type;
        s.quoted = q;
        return s;
}

  final public QuotedScalar double_quoted_string() throws ParseException {QuotedScalar q = new QuotedScalar();
  q.type = YamlScalarTypes.DOUBLE;
  Token f;
  Token s;
  Token e;
  Token cs = null;
  Token ce = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_QUOTED_FIRST:{
      f = jj_consume_token(DOUBLE_QUOTED_FIRST);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONTINUATION_END:{
        ce = jj_consume_token(CONTINUATION_END);
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        ;
      }
// if there is a continuation char then preserve ending whitespace
        q.setFirstLine(f.image);
        if (ce != null) q.firstLineHasContinuation = true;
        ce = null;
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_START:
        case STRING_DOUBLE_BODY_SECOND:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_5;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_START:{
          cs = jj_consume_token(CONTINUATION_START);
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          ;
        }
        s = jj_consume_token(STRING_DOUBLE_BODY_SECOND);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_END:{
          ce = jj_consume_token(CONTINUATION_END);
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          ;
        }
// add possible skeleton;
                q.addLine(new Line(ignorableTextBefore(s, false)));
                // add indented line and indent column
                // if continuation characters at start or end
                // then preserve start or end whitespace
                Line ql = new Line(s.image, s.beginColumn, false);
                ql.setContinuation(cs == null ? false : true, ce == null ? false : true);
                q.addLine(ql);
      }
      jj_consume_token(QUOTE_DOUBLE_END);
      break;
      }
    case DOUBLE_QUOTED_EMPTY:{
      e = jj_consume_token(DOUBLE_QUOTED_EMPTY);
q.setFirstLine("");
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return q;
}

  final public QuotedScalar single_quoted_string() throws ParseException {QuotedScalar q = new QuotedScalar();
  q.type = YamlScalarTypes.SINGLE;
  Token f;
  Token s;
  Token e;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_FIRST:{
      f = jj_consume_token(SINGLE_QUOTED_FIRST);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CONTINUATION_END:{
        jj_consume_token(CONTINUATION_END);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        ;
      }
q.setFirstLine(f.image);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_START:
        case STRING_SINGLE_BODY_SECOND:{
          ;
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_6;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_START:{
          jj_consume_token(CONTINUATION_START);
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          ;
        }
        s = jj_consume_token(STRING_SINGLE_BODY_SECOND);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CONTINUATION_END:{
          jj_consume_token(CONTINUATION_END);
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          ;
        }
// add possible skeleton;
                q.addLine(new Line(ignorableTextBefore(s, false)));
                // add indented line and indent column
                q.addLine(new Line(s.image, s.beginColumn, false));
      }
      jj_consume_token(QUOTE_SINGLE_END);
      break;
      }
    case SINGLE_QUOTED_EMPTY:{
      e = jj_consume_token(SINGLE_QUOTED_EMPTY);
q.setFirstLine("");
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return q;
}

  final public Scalar plain_scalar() throws ParseException {IndentedBlock indented; Token t = null;
    // syntacticaly, indented_plain_scalar() is optional but we only determine
      // this semantically (inside the Java code)
      t = jj_consume_token(PLAIN_SCALAR);
    indented = indented_plain_scalar();
Scalar s = new Scalar();
        s.type = YamlScalarTypes.PLAIN;
        // trim in case a comment forced the lexer to eat some whitespace
        s.scalar = t.image.trim();
        s.indentedBlock = indented;
        return s;
}

  final public Scalar literal_style() throws ParseException {IndentedBlock indented; Token t;
    t = jj_consume_token(LITERAL_SCALAR_START);
handler.handleMarker(t.image);
    indented = indented_block_scalar(YamlScalarTypes.LITERAL);
Scalar s = new Scalar();
        s.type = YamlScalarTypes.LITERAL;
        s.indentedBlock = indented;
        s.setChomp(t.image);
        return s;
}

  final public Scalar folded_style() throws ParseException {IndentedBlock indented; Token t;
    t = jj_consume_token(FOLDED_SCALAR_START);
handler.handleMarker(t.image);
    indented = indented_block_scalar(YamlScalarTypes.FOLDED);
Scalar s = new Scalar();
        s.type = YamlScalarTypes.FOLDED;
        s.indentedBlock = indented;
        s.setChomp(t.image);
        return s;
}

  final public IndentedBlock indented_plain_scalar() throws ParseException {IndentedBlock ib = new IndentedBlock(); ib.type = YamlScalarTypes.PLAIN; Token t = null;
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLAIN_SCALAR_INDENTED:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_7;
      }
      t = jj_consume_token(PLAIN_SCALAR_INDENTED);
// add possible skeleton to TU, but not first newlines
                ib.addLine(new Line(ignorableTextBefore(t, false)));

                // add indented line and indent column
                ib.addLine(new Line(t.image, t.beginColumn, false));
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL_SCALAR:{
      jj_consume_token(NULL_SCALAR);
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
if (ib.isEmpty()) return null; return ib;
}

  final public IndentedBlock indented_block_scalar(YamlScalarTypes type) throws ParseException {boolean firstSkeleton = true; IndentedBlock ib = new IndentedBlock(); ib.type = type; Token t = null;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LITERAL_FOLDED_INDENTED:{
        ;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_8;
      }
      t = jj_consume_token(LITERAL_FOLDED_INDENTED);
// add possible skeleton to TU, but not first newlines
                ib.addLine(new Line(ignorableTextBefore(t, firstSkeleton)));
                firstSkeleton = false;

                // add indented line and indent column
                ib.addLine(new Line(t.image, t.beginColumn, false));
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL_SCALAR:{
      jj_consume_token(NULL_SCALAR);
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
if (ib.isEmpty()) return null; return ib;
}

  final public void flow_node() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FLOW_SEQUENCE_START:{
      flow_sequence();
      break;
      }
    case FLOW_MAPPING_START:{
      flow_mapping();
      break;
      }
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:
    case PLAIN_FLOW_SCALAR:{
      flow_scalar();
      break;
      }
    case ALIAS:{
      t = jj_consume_token(ALIAS);
handler.handleOther(t.image);
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void sequence() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FLOW_SEQUENCE_START:{
      flow_sequence();
      break;
      }
    case BLOCK_SEQUENCE_START:{
      block_sequence();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void flow_sequence() throws ParseException {Token t;
handler.handleSequenceStart(true);
    jj_consume_token(FLOW_SEQUENCE_START);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALIAS:
      case FLOW_SEQUENCE_START:
      case FLOW_MAPPING_START:
      case SINGLE_QUOTED_EMPTY:
      case DOUBLE_QUOTED_EMPTY:
      case SINGLE_QUOTED_FIRST:
      case DOUBLE_QUOTED_FIRST:
      case PLAIN_FLOW_SCALAR:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_9;
      }
      flow_sequence_entry();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LIST_SEPERATOR:{
        t = jj_consume_token(LIST_SEPERATOR);
handler.handleMarker(t.image);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
    }
    jj_consume_token(FLOW_SEQUENCE_END);
handler.handleSequenceEnd(true);
}

  final public void flow_sequence_entry() throws ParseException {
    flow_node();
}

  final public void indentless_block_sequence() throws ParseException {
    label_10:
    while (true) {
      block_sequence_element();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DASH:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_10;
      }
    }
}

  final public void block_sequence() throws ParseException {
handler.handleSequenceStart(false);
    jj_consume_token(BLOCK_SEQUENCE_START);
    label_11:
    while (true) {
      block_sequence_element();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DASH:{
        ;
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        break label_11;
      }
    }
    jj_consume_token(BLOCK_END);
handler.handleSequenceEnd(false);
}

  final public void block_sequence_element() throws ParseException {Token t;
    t = jj_consume_token(DASH);
handler.handleBlockSequenceNodeStart(t.image, t.beginColumn);
    node();
}

  final public Key key() throws ParseException {Token t = null; Key k = new Key();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_KEY:{
      t = jj_consume_token(SINGLE_QUOTED_KEY);
k.key=t.image; k.type=YamlScalarTypes.SINGLE;
      break;
      }
    case DOUBLE_QUOTED_KEY:{
      t = jj_consume_token(DOUBLE_QUOTED_KEY);
k.key=t.image; k.type=YamlScalarTypes.DOUBLE;
      break;
      }
    case PLAIN_KEY:{
      t = jj_consume_token(PLAIN_KEY);
k.key=t.image; k.type=YamlScalarTypes.PLAIN;
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
k.indent = t.beginColumn; return k;
}

  final public Key flow_key() throws ParseException {Token t = null; Key k = new Key(); k.flow = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_KEY:{
      t = jj_consume_token(SINGLE_QUOTED_KEY);
k.key=t.image; k.type=YamlScalarTypes.SINGLE;
      break;
      }
    case DOUBLE_QUOTED_KEY:{
      t = jj_consume_token(DOUBLE_QUOTED_KEY);
k.key=t.image; k.type=YamlScalarTypes.DOUBLE;
      break;
      }
    case PLAIN_FLOW_KEY:{
      t = jj_consume_token(PLAIN_FLOW_KEY);
k.key=t.image; k.type=YamlScalarTypes.PLAIN;
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return k;
}

  final public void mapping() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FLOW_MAPPING_START:{
      flow_mapping();
      break;
      }
    case BLOCK_MAPPING_START:{
      block_mapping();
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void flow_mapping() throws ParseException {Token t;
handler.handleMapStart(true);
    jj_consume_token(FLOW_MAPPING_START);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALIAS:
      case FLOW_SEQUENCE_START:
      case FLOW_MAPPING_START:
      case SINGLE_QUOTED_EMPTY:
      case DOUBLE_QUOTED_EMPTY:
      case SINGLE_QUOTED_FIRST:
      case DOUBLE_QUOTED_FIRST:
      case SINGLE_QUOTED_KEY:
      case DOUBLE_QUOTED_KEY:
      case PLAIN_FLOW_SCALAR:
      case PLAIN_FLOW_KEY:{
        ;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_12;
      }
      flow_mapping_element();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LIST_SEPERATOR:{
        t = jj_consume_token(LIST_SEPERATOR);
handler.handleMarker(t.image);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
    }
    jj_consume_token(FLOW_MAPPING_END);
handler.handleMapEnd(true);
}

  final public void flow_mapping_element() throws ParseException {Key k = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTED_KEY:
    case DOUBLE_QUOTED_KEY:
    case PLAIN_FLOW_KEY:{
      k = flow_key();
handler.handleKey(k);
      flow_node();
handler.handleMappingElementEnd();
      break;
      }
    case ALIAS:
    case FLOW_SEQUENCE_START:
    case FLOW_MAPPING_START:
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:
    case PLAIN_FLOW_SCALAR:{
      flow_node();
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void block_mapping() throws ParseException {
handler.handleMapStart(false);
    jj_consume_token(BLOCK_MAPPING_START);
    label_13:
    while (true) {
      block_mapping_element();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SINGLE_QUOTED_KEY:
      case DOUBLE_QUOTED_KEY:
      case PLAIN_KEY:{
        ;
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_13;
      }
    }
    jj_consume_token(BLOCK_END);
handler.handleMapEnd(false);
}

  final public void block_mapping_element() throws ParseException {Key k; Token kl = null;
    k = key();
handler.handleKey(k);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLOCK_SEQUENCE_START:
    case BLOCK_MAPPING_START:
    case TAG:
    case TAG_DIRECTIVE:
    case ANCHOR:
    case ALIAS:
    case FLOW_SEQUENCE_START:
    case FLOW_MAPPING_START:
    case SINGLE_QUOTED_EMPTY:
    case DOUBLE_QUOTED_EMPTY:
    case SINGLE_QUOTED_FIRST:
    case DOUBLE_QUOTED_FIRST:
    case LITERAL_SCALAR_START:
    case FOLDED_SCALAR_START:
    case DASH:
    case PLAIN_SCALAR:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BLOCK_SEQUENCE_START:
      case BLOCK_MAPPING_START:
      case TAG:
      case TAG_DIRECTIVE:
      case ANCHOR:
      case ALIAS:
      case FLOW_SEQUENCE_START:
      case FLOW_MAPPING_START:
      case SINGLE_QUOTED_EMPTY:
      case DOUBLE_QUOTED_EMPTY:
      case SINGLE_QUOTED_FIRST:
      case DOUBLE_QUOTED_FIRST:
      case LITERAL_SCALAR_START:
      case FOLDED_SCALAR_START:
      case PLAIN_SCALAR:{
        node();
        break;
        }
      case DASH:{
        indentless_block_sequence();
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
handler.handleMappingElementEnd();
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3R_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(SINGLE_QUOTED_EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    }
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(STRING_SINGLE_BODY_SECOND)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) return true;
    }
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(SINGLE_QUOTED_FIRST)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_75()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(QUOTE_SINGLE_END)) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_scan_token(TAG_DIRECTIVE)) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_scan_token(ALIAS)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(BLOCK_MAPPING_START)) return true;
    Token xsp;
    if (jj_3R_45()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_scan_token(LITERAL_FOLDED_INDENTED)) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_56()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(5)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_16()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_15()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    if (jj_scan_token(DOCUMENT_END)) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_scan_token(DOUBLE_QUOTED_EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_scan_token(FLOW_MAPPING_START)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_44()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(FLOW_MAPPING_END)) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(PLAIN_SCALAR_INDENTED)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    }
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_57()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(5)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(PLAIN_FLOW_KEY)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(STRING_DOUBLE_BODY_SECOND)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(ALIAS)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(DOUBLE_QUOTED_KEY)) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(SINGLE_QUOTED_KEY)) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_scan_token(DOUBLE_QUOTED_FIRST)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_74()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(QUOTE_DOUBLE_END)) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(PLAIN_KEY)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(DOUBLE_QUOTED_KEY)) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_scan_token(FOLDED_SCALAR_START)) return true;
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(SINGLE_QUOTED_KEY)) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(DASH)) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(LITERAL_SCALAR_START)) return true;
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    }
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_scan_token(BLOCK_SEQUENCE_START)) return true;
    Token xsp;
    if (jj_3R_43()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(PLAIN_SCALAR)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_scan_token(FLOW_SEQUENCE_START)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_42()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(FLOW_SEQUENCE_END)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public YamlParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x800,0x7808f64c,0x80040,0x7808f64c,0x40,0x40,0x1200,0x7800e40c,0x1200,0x78000000,0x78000000,0x78000000,0x80000000,0x0,0x0,0x80000000,0x50000000,0x80000000,0x0,0x0,0x80000000,0x28000000,0x0,0x20,0x0,0x20,0x7800e000,0x4004,0x7800e000,0x40000,0x0,0x0,0x0,0x0,0x8008,0x7800e000,0x40000,0x7800e000,0x0,0x7800f60c,0x7800f60c,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x20c0,0x0,0x20c0,0x0,0x0,0x0,0x20c0,0x0,0x20c0,0x20000,0x0,0x0,0x3,0x1,0x0,0x0,0x0,0x9,0x1,0x0,0x0,0x8000,0x0,0x10000,0x0,0x20000,0x0,0x20000,0x0,0x100,0x100,0x4c00,0x40c00,0x0,0x60c00,0x0,0x60c00,0x4c00,0x21c0,0x21c0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public YamlParser(Provider stream) {
	 jj_input_stream = new JavaCharStream(stream, 1, 1);
	 token_source = new YamlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public YamlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new JavaCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new YamlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public YamlParser(YamlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(YamlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[53];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 41; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 53; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : YamlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 2; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
