/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeComparatorOnData;
import net.sf.okapi.common.resource.CodeComparatorOnId;
import net.sf.okapi.common.resource.CodeComparatorOnIsolated;
import net.sf.okapi.common.resource.CodeComparatorOnTagType;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextFragmentUtil {
    public static final int MAX_INLINE_CODES = 6127;
    public static final CodeComparatorOnData CMP_DATA = new CodeComparatorOnData();
    public static final CodeComparatorOnId CMP_ID = new CodeComparatorOnId();
    public static final CodeComparatorOnTagType CMP_TAG_TYPE = new CodeComparatorOnTagType();
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFragmentUtil.class);

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to, boolean addMissingCodes, boolean forceCopy) {
        if (from == null || to == null) {
            return CodeMatches.NO_CODES;
        }
        CodeMatches cm = TextFragmentUtil.synchronizeCodeIds(from, to);
        if (cm == CodeMatches.SAME_CODES) {
            return cm;
        }
        TextFragmentUtil.copyCodeMetadata(from, to, forceCopy, cm);
        if (addMissingCodes && (cm.hasFromMismatch() || cm.hasToMismatch())) {
            TextFragmentUtil.addMissingCodes(from, to, cm);
        }
        return cm;
    }

    public static void logCodeMismatchErrors(CodeMatches matches, TextFragment from, TextFragment to, String textUnitId) {
        String warn;
        if (textUnitId != null && (matches.hasFromMismatch() || matches.hasToMismatch())) {
            LOGGER.warn("Code mismatch in TextUnit {}", (Object)textUnitId);
        }
        if (matches.hasToMismatch()) {
            for (Integer index : matches.getToMismatchIterator()) {
                warn = TextFragmentUtil.buildErrorString(to, index);
                if (warn == null) continue;
                LOGGER.warn("Can't find matching Code(s) {}", (Object)warn);
            }
        }
        if (matches.hasFromMismatch()) {
            for (Integer index : matches.getFromMismatchIterator()) {
                warn = TextFragmentUtil.buildErrorString(from, index);
                if (warn == null) continue;
                LOGGER.warn("Can't find matching Code(s) {}", (Object)warn);
            }
        }
    }

    private static String buildErrorString(TextFragment f, Integer index) {
        int mi;
        Code c = f.getCode(index);
        if (c.isAdded() || c.isDeleteable() || c.isCloneable()) {
            return null;
        }
        StringBuilder warn = new StringBuilder(String.format("id='%s' originalId='%s' data='%s'", c.id, c.originalId == null ? "" : c.originalId, TextFragmentUtil.getCodeDataOrSimulate(c)));
        if (c.getTagType() == TextFragment.TagType.OPENING && (mi = f.getIndexForClosing(c.id)) != -1) {
            Code m = f.getCode(mi);
            warn.append(String.format(", Closing data='%s'", TextFragmentUtil.getCodeDataOrSimulate(m)));
        }
        return warn.toString();
    }

    private static String getCodeDataOrSimulate(Code c) {
        if (!Util.isEmpty(c.getData())) {
            return c.getData();
        }
        StringBuilder b = new StringBuilder();
        switch (c.tagType) {
            case OPENING: {
                b.append("<").append(c.type).append(" id=").append(c.id).append(">");
                break;
            }
            case CLOSING: {
                b.append("</").append(c.type).append(">");
                break;
            }
            case PLACEHOLDER: {
                b.append("<").append(c.type).append(" id=").append(c.id).append("/>");
            }
        }
        return b.toString();
    }

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to) {
        return TextFragmentUtil.alignAndCopyCodeMetadata(from, to, false, false);
    }

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to, boolean addMissingCodes) {
        return TextFragmentUtil.alignAndCopyCodeMetadata(from, to, addMissingCodes, false);
    }

    public static void addMissingCodes(TextFragment from, TextFragment to, CodeMatches codeMatches) {
        TextFragment leadingCodes = new TextFragment();
        for (Integer index : codeMatches.getFromMismatchIterator()) {
            Code fc = from.codes.get(index);
            if (TextFragmentUtil.isLeadingCode(fc, from)) {
                leadingCodes.append(fc.clone());
            } else {
                to.append(fc.clone());
            }
            codeMatches.setFromMatch(index, CodeMatches.ADDED_MATCH);
        }
        to.insert(0, leadingCodes, true);
        to.invalidate();
        to.balanceMarkers();
    }

    public static boolean isLeadingCode(Code code, TextFragment source) {
        int index = source.codes.indexOf(code);
        if (index == -1) {
            return false;
        }
        String ctext = source.getCodedText();
        int pos = ctext.indexOf(String.valueOf(TextFragment.toChar(index)));
        if (pos == -1) {
            return false;
        }
        String substr = ctext.substring(0, pos - 1);
        return (substr = TextFragment.MARKERS_REGEX.matcher(substr).replaceAll("")).trim().length() == 0;
    }

    @SafeVarargs
    public static int findMatch(Code orig, List<Code> codes, int[] fromMatches, Comparator<Code> ... cmps) {
        int i = -1;
        for (Code c : codes) {
            if (fromMatches[++i] != CodeMatches.NO_MATCH || !TextFragmentUtil.compareAll(orig, c, i, cmps)) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    static <T> boolean compareAll(T from, T to, int index, Comparator<T> ... cmps) {
        for (Comparator<T> cmp : cmps) {
            if (cmp instanceof CodeComparatorOnIsolated) {
                ((CodeComparatorOnIsolated)cmp).setFromIndex(index);
            }
            if (cmp.compare(from, to) == 0) continue;
            return false;
        }
        return true;
    }

    public static void copyCodeMetadata(TextFragment sf, TextFragment tf, boolean forceCopy, CodeMatches cm) {
        if (sf == null || tf == null) {
            return;
        }
        if (sf.codes == null || tf.codes == null) {
            return;
        }
        int toIndex = -1;
        int[] nArray = cm.getToMatches();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer fromIndex = nArray[i];
            ++toIndex;
            if (fromIndex == CodeMatches.NO_MATCH) continue;
            Code sc = sf.codes.get(fromIndex);
            Code tc = tf.codes.get(toIndex);
            if (sc.hasOnlyAnnotation()) continue;
            TextFragmentUtil.copyCodeMetadata(sc, tc, forceCopy);
        }
    }

    public static void copyCodeMetadata(Code sc, Code tc, boolean forceCopy) {
        tc.setOuterData(null);
        if (forceCopy || !tc.hasData() || sc.hasReference()) {
            tc.setData(sc.getData());
            tc.setReferenceFlag(sc.hasReference());
        }
        tc.setOuterData(sc.getOuterData());
        tc.setOriginalId(sc.getOriginalId());
        tc.setAdded(sc.isAdded());
        tc.setCloneable(sc.isCloneable());
        tc.setDeleteable(sc.isDeleteable());
        tc.setDisplayText(sc.getDisplayText());
        tc.setFlag(sc.getFlag());
        tc.setMerged(sc.isMerged());
        tc.setMarkerMasking(sc.isMarkerMasking());
        tc.setMergedData(sc.getMergedData());
        tc.setTagType(sc.getTagType());
        tc.setType(sc.getType());
        Set<String> types = sc.getAnnotationsTypes();
        for (String type : types) {
            if ("PROPERTIES".equals(type)) continue;
            InlineAnnotation a = sc.getAnnotation(type);
            tc.setAnnotation(type, a.clone());
        }
        IWithProperties.copy(sc, tc);
    }

    public static CodeMatches synchronizeCodeIds(TextFragment from, TextFragment to) {
        if (from == null || to == null) {
            return CodeMatches.NO_CODES;
        }
        if (!from.hasCode() && !to.hasCode()) {
            return CodeMatches.NO_CODES;
        }
        if (from == to) {
            return CodeMatches.SAME_CODES;
        }
        if (from.codes == null) {
            from.setCodes(new ArrayList<Code>());
        }
        if (to.codes == null) {
            to.setCodes(new ArrayList<Code>());
        }
        from.balanceMarkers();
        to.balanceMarkers();
        CodeMatches codeMatches = new CodeMatches(from, to);
        CodeComparatorOnIsolated cmpIsolated = new CodeComparatorOnIsolated(codeMatches);
        for (int index = 0; index < to.codes.size(); ++index) {
            Code tc = to.codes.get(index);
            if (tc.hasOnlyAnnotation() || tc.tagType == TextFragment.TagType.CLOSING && !codeMatches.isToIsolated(index)) continue;
            cmpIsolated.setToIndex(index);
            int fromIndex = TextFragmentUtil.search(tc, index, from.codes, codeMatches, cmpIsolated);
            if (fromIndex == -1) continue;
            Code fc = from.codes.get(fromIndex);
            if (tc.tagType == TextFragment.TagType.OPENING && fc.tagType == TextFragment.TagType.OPENING && !codeMatches.isToIsolated(index)) {
                if (TextFragmentUtil.matchClosing(codeMatches, to, from, index, fromIndex, cmpIsolated)) continue;
                codeMatches.setToMatch(index, CodeMatches.NO_MATCH);
                LOGGER.error("Cannot find matching closing tag. Malformed TextFragment. id={} data={}", (Object)tc.getId(), (Object)tc);
                continue;
            }
            codeMatches.setToMatch(index, fromIndex);
            tc.setId(fc.id);
        }
        to.invalidate();
        to.balanceMarkers();
        return codeMatches;
    }

    static boolean matchClosing(CodeMatches codeMatches, TextFragment to, TextFragment from, int index, int fromIndex, CodeComparatorOnIsolated cmpLoose) {
        if (fromIndex < 0 || fromIndex >= from.codes.size()) {
            return false;
        }
        Code tc = to.codes.get(index);
        Code fc = from.codes.get(fromIndex);
        int fpos = -1;
        int tpos = -1;
        if (!codeMatches.isFromIsolated(fromIndex)) {
            tpos = to.findClosingCodePosition(tc.getId(), index);
            fpos = from.findClosingCodePosition(fc.getId(), fromIndex);
        }
        if (fpos == -1 || tpos == -1) {
            if (TextFragmentUtil.matchClosing(codeMatches, to, from, index, TextFragmentUtil.search(tc, index, from.codes, codeMatches, cmpLoose), cmpLoose)) {
                return true;
            }
            codeMatches.setFromMatch(fromIndex, CodeMatches.NO_MATCH);
            return false;
        }
        int fi = TextFragment.toIndex(from.charAt(fpos + 1));
        int ti = TextFragment.toIndex(to.charAt(tpos + 1));
        assert (fi >= 0 && fi < from.codes.size());
        assert (ti >= 0 && ti < to.codes.size());
        Code ctc = to.codes.get(ti);
        Code cfc = from.codes.get(fi);
        tc.setId(fc.getId());
        ctc.setId(cfc.getId());
        codeMatches.setToMatch(index, fromIndex);
        codeMatches.setToMatch(ti, fi);
        codeMatches.setFromMatch(fi, ti);
        return true;
    }

    static int search(Code tc, int index, List<Code> codes, CodeMatches codeMatches, Comparator<Code> cmpIsolated) {
        if (!codeMatches.hasFromMismatch()) {
            return -1;
        }
        CodeComparatorOnIsolated cmpTagTypeWithIsolated = new CodeComparatorOnIsolated(codeMatches, false);
        int fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_ID, CMP_TAG_TYPE, cmpIsolated, CMP_DATA);
        if (fromIndex == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_TAG_TYPE, cmpIsolated, CMP_DATA)) == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_ID, CMP_TAG_TYPE, cmpIsolated)) == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), cmpTagTypeWithIsolated, CMP_DATA)) == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), cmpTagTypeWithIsolated)) == -1) {
            return -1;
        }
        codeMatches.setFromMatch(fromIndex, index);
        return fromIndex;
    }

    public static boolean moreThanMaxCodes(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        return codes.size() > 6127;
    }

    public static TextFragment removeMoreThanMaxCodes(TextFragment tf) {
        int c;
        int i;
        int lastCodeIndex = 0;
        int lastCharIndex = 0;
        String codedText = tf.getCodedText();
        StringBuilder newCodedText = new StringBuilder();
        List<Code> codes = tf.getCodes();
        for (i = 0; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                if (lastCodeIndex > 6126) {
                    lastCharIndex = i - 1;
                    break;
                }
                switch (c) {
                    case 57601: {
                        newCodedText.append("\ue101").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57602: {
                        newCodedText.append("\ue102").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57603: {
                        newCodedText.append("\ue103").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                    }
                }
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        for (i = lastCharIndex; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                ++i;
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        return new TextFragment(newCodedText.toString(), codes.subList(0, lastCodeIndex + 1));
    }

    public static String toText(TextFragment tf) {
        if (tf.codes == null || tf.codes.size() == 0) {
            return tf.toString();
        }
        if (!tf.isBalanced) {
            tf.balanceMarkers();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < tf.length(); ++i) {
            switch (tf.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = tf.codes.get(TextFragment.toIndex(tf.charAt(++i)));
                    tmp.append(code.getOuterData());
                    continue block3;
                }
                default: {
                    tmp.append(tf.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

