/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinebuilder;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipelinebuilder.XBatchItem;
import net.sf.okapi.common.pipelinebuilder.XDocument;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;

public class XBatch
extends XBatchItem {
    private List<IBatchItemContext> items = new ArrayList<IBatchItemContext>();

    public XBatch() {
        super(new XDocument[0]);
    }

    public XBatch(XBatchItem ... items) {
        this();
        this.addItems(items);
    }

    public void setItems(List<IBatchItemContext> items) {
        this.items = items;
    }

    public List<IBatchItemContext> getItems() {
        return this.items;
    }

    public XBatch addItems(XBatchItem ... items) {
        for (XBatchItem item : items) {
            if (item instanceof XBatch) {
                this.items.addAll(((XBatch)item).getItems());
                continue;
            }
            this.items.add(item.getContext());
        }
        return this;
    }

    public XBatch addItem(XBatchItem item) {
        if (item instanceof XBatch) {
            this.items.addAll(((XBatch)item).getItems());
        } else {
            this.items.add(item.getContext());
        }
        return this;
    }

    public XBatch addItems(String dir, String[] fileList, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        for (String file : fileList) {
            this.items.add(new XBatchItem(Util.toURI(dir + file), defaultEncoding, sourceLocale, targetLocale).getContext());
        }
        return this;
    }

    public XBatch addItems(String dir, String[] fileList, String defaultEncoding, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        for (String file : fileList) {
            this.items.add(new XBatchItem(Util.toURI(dir + file), defaultEncoding, outputURI, outputEncoding, sourceLocale, targetLocale).getContext());
        }
        return this;
    }

    public XBatch addItem(String dir, String file, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.items.add(new XBatchItem(Util.toURI(dir + file), defaultEncoding, sourceLocale, targetLocale).getContext());
        return this;
    }

    public XBatch addItem(String dir, String file, String defaultEncoding, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.items.add(new XBatchItem(Util.toURI(dir + file), defaultEncoding, outputURI, outputEncoding, sourceLocale, targetLocale).getContext());
        return this;
    }

    public void clearItems() {
        this.items.clear();
    }
}

