/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;

public class TMXContent {
    public static final int CODEMODE_ORIGINAL = 0;
    public static final int CODEMODE_EMPTY = 1;
    public static final int CODEMODE_GENERIC = 2;
    public static final int CODEMODE_LETTERCODED = 3;
    private String codedText;
    private List<Code> codes;
    private boolean withTradosWorkarounds = false;
    private int defaultQuoteMode = 1;
    private int codeMode = 0;
    private int letterCodeOffset = 0;
    private CharsetEncoder chsEnc = null;
    Stack<Integer> otStack = new Stack();

    public TMXContent() {
        this.codedText = "";
    }

    public TMXContent(TextFragment content) {
        this.setContent(content);
    }

    public void setCharsetEncoder(CharsetEncoder chsEnc) {
        this.chsEnc = chsEnc;
    }

    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    public void setTradosWorkarounds(boolean value) {
        this.withTradosWorkarounds = value;
    }

    public void setLetterCodedMode(boolean value, boolean zeroBased) {
        if (value) {
            this.codeMode = 3;
        }
        this.letterCodeOffset = zeroBased ? 1 : 0;
    }

    public boolean getLetterCodedMode() {
        return this.codeMode == 3;
    }

    public void setQuoteMode(int quoteMode) {
        this.defaultQuoteMode = quoteMode;
    }

    public int getCodeMode() {
        return this.codeMode;
    }

    public void setCodeMode(int codeMode) {
        this.codeMode = codeMode;
    }

    public TMXContent setContent(TextFragment content) {
        this.codedText = content.getCodedText();
        this.codes = content.getCodes();
        return this;
    }

    public String toString() {
        return this.toString(this.defaultQuoteMode, true);
    }

    public String toString(int quoteMode, boolean escapeGT) {
        StringBuilder tmp = new StringBuilder();
        this.otStack.clear();
        block20: for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (code.hasAnnotation("protected")) {
                        tmp.append((CharSequence)this.createTmxInlineTag("hi", this.getXValue(code), null, "protected", null));
                        continue block20;
                    }
                    if (code.hasProperty(Property.TMX_hi)) {
                        Property p = code.getProperty(Property.TMX_hi);
                        tmp.append((CharSequence)this.createTmxInlineTag("hi", this.getXValue(code), null, p.getValue(), null));
                        continue block20;
                    }
                    tmp.append((CharSequence)this.createTmxInlineTag("bpt", this.getXValue(code), String.valueOf(code.getId()), code.getType(), null));
                    tmp.append((CharSequence)this.createTagContent(quoteMode, escapeGT, code, 57601, TextFragment.TagType.OPENING));
                    tmp.append("</bpt>");
                    continue block20;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (code.hasAnnotation("protected") || code.hasProperty(Property.TMX_hi)) {
                        tmp.append("</hi>");
                        continue block20;
                    }
                    tmp.append((CharSequence)this.createTmxInlineTag("ept", null, String.valueOf(code.getId()), null, null));
                    tmp.append((CharSequence)this.createTagContent(quoteMode, escapeGT, code, 57602, TextFragment.TagType.CLOSING));
                    tmp.append("</ept>");
                    continue block20;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    switch (code.getTagType()) {
                        case PLACEHOLDER: {
                            if (this.withTradosWorkarounds && (code.getData().indexOf(123) != -1 || code.getData().indexOf(125) != -1 || code.getData().indexOf(92) != -1)) {
                                tmp.append("<ut>{\\cs6\\f1\\cf6\\lang1024 </ut>");
                                tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                                tmp.append("<ut>}</ut>");
                                break;
                            }
                            tmp.append((CharSequence)this.createTmxInlineTag("ph", this.getXValue(code), null, code.getType(), null));
                            tmp.append((CharSequence)this.createTagContent(quoteMode, escapeGT, code, 57603, TextFragment.TagType.PLACEHOLDER));
                            tmp.append("</ph>");
                            break;
                        }
                        case OPENING: {
                            tmp.append((CharSequence)this.createTmxInlineTag("it", this.getXValue(code), null, code.getType(), "begin"));
                            tmp.append((CharSequence)this.createTagContent(quoteMode, escapeGT, code, 57603, TextFragment.TagType.OPENING));
                            tmp.append("</it>");
                            break;
                        }
                        case CLOSING: {
                            tmp.append((CharSequence)this.createTmxInlineTag("it", this.getXValue(code), null, code.getType(), "end"));
                            tmp.append((CharSequence)this.createTagContent(quoteMode, escapeGT, code, 57603, TextFragment.TagType.CLOSING));
                            tmp.append("</it>");
                        }
                    }
                    continue block20;
                }
                case 62: {
                    if (escapeGT) {
                        tmp.append("&gt;");
                        continue block20;
                    }
                    if (i > 0 && this.codedText.charAt(i - 1) == ']') {
                        tmp.append("&gt;");
                        continue block20;
                    }
                    tmp.append('>');
                    continue block20;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block20;
                }
                case 13: {
                    tmp.append("&#13;");
                    continue block20;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block20;
                }
                case 34: {
                    if (quoteMode > 0) {
                        tmp.append("&quot;");
                        continue block20;
                    }
                    tmp.append('\"');
                    continue block20;
                }
                case 39: {
                    switch (quoteMode) {
                        case 1: {
                            tmp.append("&apos;");
                            continue block20;
                        }
                        case 2: {
                            tmp.append("&#39;");
                            continue block20;
                        }
                    }
                    tmp.append(this.codedText.charAt(i));
                    continue block20;
                }
                default: {
                    if (this.codedText.charAt(i) > '\u007f') {
                        if (Character.isHighSurrogate(this.codedText.charAt(i))) {
                            int cp = this.codedText.codePointAt(i++);
                            String buf = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(buf)) {
                                tmp.append(String.format("&#x%X;", cp));
                                continue block20;
                            }
                            tmp.append(buf);
                            continue block20;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(this.codedText.charAt(i))) {
                            tmp.append(String.format("&#x%04X;", this.codedText.codePointAt(i)));
                            continue block20;
                        }
                        tmp.append(this.codedText.charAt(i));
                        continue block20;
                    }
                    tmp.append(this.codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    private StringBuilder createTagContent(int quoteMode, boolean escapeGT, Code code, int markerType, TextFragment.TagType tagType) {
        StringBuilder tmp = new StringBuilder();
        block0 : switch (markerType) {
            case 57601: {
                switch (this.codeMode) {
                    case 2: {
                        this.otStack.push(code.getId());
                        tmp.append(Util.escapeToXML(String.format("<%d>", code.getId()), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case 3: {
                        int id = code.getId() - this.letterCodeOffset;
                        this.otStack.push(id);
                        tmp.append(Util.escapeToXML(String.format("<g%d>", id), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                break;
            }
            case 57602: {
                switch (this.codeMode) {
                    case 2: {
                        tmp.append(Util.escapeToXML(String.format("</%d>", this.otStack.pop()), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case 3: {
                        tmp.append(Util.escapeToXML(String.format("</g%d>", this.otStack.pop()), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                break;
            }
            case 57603: {
                switch (tagType) {
                    case PLACEHOLDER: {
                        switch (this.codeMode) {
                            case 2: {
                                tmp.append(Util.escapeToXML(String.format("<%d/>", code.getId()), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 3: {
                                int id = code.getId() - this.letterCodeOffset;
                                tmp.append(Util.escapeToXML(String.format("<x%d/>", id), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 1: {
                                break block0;
                            }
                        }
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case OPENING: {
                        switch (this.codeMode) {
                            case 2: {
                                tmp.append(Util.escapeToXML(String.format("<%d/>", code.getId()), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 3: {
                                int id = code.getId() - this.letterCodeOffset;
                                tmp.append(Util.escapeToXML(String.format("<x%d/>", id), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 1: {
                                break block0;
                            }
                        }
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                        break block0;
                    }
                    case CLOSING: {
                        switch (this.codeMode) {
                            case 2: {
                                tmp.append(Util.escapeToXML(String.format("<%d/>", code.getId()), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 3: {
                                int id = code.getId() - this.letterCodeOffset;
                                tmp.append(Util.escapeToXML(String.format("<x%d/>", id), quoteMode, escapeGT, null));
                                break block0;
                            }
                            case 1: {
                                break block0;
                            }
                        }
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                    }
                }
            }
        }
        return tmp;
    }

    private StringBuilder createTmxInlineTag(String name, String x, String i, String type, String pos) {
        StringBuilder tag = new StringBuilder();
        tag.append(String.format("<%s", name));
        if (!Util.isEmpty(x)) {
            tag.append(String.format(" x=\"%s\"", x));
        }
        if (!Util.isEmpty(i)) {
            tag.append(String.format(" i=\"%s\"", i));
        }
        if (!Util.isEmpty(type) && !"null".equals(type)) {
            tag.append(String.format(" type=\"%s\"", type));
        }
        if (!Util.isEmpty(pos)) {
            tag.append(String.format(" pos=\"%s\"", pos));
        }
        tag.append(">");
        return tag;
    }

    private String getXValue(Code code) {
        String id = String.valueOf(code.getId());
        if (!Util.isEmpty(code.getOriginalId())) {
            id = code.getOriginalId();
        }
        return id;
    }
}

