/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters.fontmappings;

import java.util.regex.Pattern;
import net.sf.okapi.common.LocalePair;
import net.sf.okapi.common.filters.fontmappings.FontMapping;

public final class DefaultFontMapping
implements FontMapping {
    private final Pattern sourceLocalePattern;
    private final Pattern targetLocalePattern;
    private final Pattern sourceFontPattern;
    private final String targetFont;

    public DefaultFontMapping(String sourceLocaleString, String targetLocaleString, String sourceFontString, String targetFont) {
        this(Pattern.compile(sourceLocaleString), Pattern.compile(targetLocaleString), Pattern.compile(sourceFontString), targetFont);
    }

    public DefaultFontMapping(Pattern sourceLocalePattern, Pattern targetLocalePattern, Pattern sourceFontPattern, String targetFont) {
        this.sourceLocalePattern = sourceLocalePattern;
        this.targetLocalePattern = targetLocalePattern;
        this.sourceFontPattern = sourceFontPattern;
        this.targetFont = targetFont;
    }

    @Override
    public boolean applicableTo(LocalePair pair) {
        return !this.targetFont.isEmpty() && this.sourceLocalePattern.matcher(pair.source().toString()).matches() && this.targetLocalePattern.matcher(pair.target().toString()).matches();
    }

    @Override
    public boolean applicableTo(String sourceFont) {
        return !this.targetFont.isEmpty() && this.sourceFontPattern.matcher(sourceFont).matches();
    }

    @Override
    public String targetFont() {
        return this.targetFont;
    }

    @Override
    public <T> T writtenTo(FontMapping.Output<T> output) {
        return output.writtenWith(this.sourceLocalePattern, this.targetLocalePattern, this.sourceFontPattern, this.targetFont);
    }
}

