/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class JSONEncoder
implements IEncoder {
    private CharsetEncoder chsEnc;
    private boolean escapeExtendedChars = false;
    private boolean escapeForwardSlashes = true;
    private String lineBreak = "\n";
    private String encoding;
    private IParameters params;
    private char last = (char)65535;

    public JSONEncoder() {
        this.chsEnc = StandardCharsets.UTF_8.newEncoder();
    }

    @Override
    public void reset() {
        this.last = (char)65535;
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.chsEnc = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        this.params = params;
        if (params != null) {
            this.escapeExtendedChars = params.getBoolean("escapeExtendedChars");
            this.escapeForwardSlashes = params.getBoolean("escapeForwardSlashes");
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        StringBuilder sbTmp = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            sbTmp.append(this.encode(text.charAt(i), context));
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        String rv = this._encode(value, context);
        this.last = value;
        return rv;
    }

    protected String _encode(char value, EncoderContext context) {
        if (value > '\u007f') {
            if (Character.isHighSurrogate(value)) {
                return "";
            }
            if (Character.isHighSurrogate(this.last)) {
                int cp = Character.toCodePoint(this.last, value);
                String tmp = new String(Character.toChars(cp));
                if (this.escapeExtendedChars || !this.chsEnc.canEncode(tmp)) {
                    return String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1));
                }
                return tmp;
            }
            if (this.escapeExtendedChars || !this.chsEnc.canEncode(value)) {
                return String.format("\\u%04x", value);
            }
            return String.valueOf(value);
        }
        switch (value) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '/': {
                return this.escapeForwardSlashes ? "\\" + value : String.valueOf(value);
            }
            case '\"': 
            case '\\': {
                return "\\" + value;
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            String tmp = new String(Character.toChars(value));
            if (this.escapeExtendedChars || !this.chsEnc.canEncode(tmp)) {
                return String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1));
            }
            return tmp;
        }
        return this.encode((char)value, context);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

