/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.impl;

import java.util.Collection;
import javax.inject.Inject;
import net.sf.mmm.util.exception.api.ValueConvertException;
import net.sf.mmm.util.exception.api.ValueException;
import net.sf.mmm.util.pojo.api.PojoFactory;
import net.sf.mmm.util.pojo.base.GuessingPojoFactory;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilderFactory;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyNotFoundException;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorOneArgMode;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorBuilderFactoryImpl;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.value.base.AbstractRecursiveValueConverter;

public abstract class AbstractValueConverterToCompatiblePojo<SOURCE, TARGET>
extends AbstractRecursiveValueConverter<SOURCE, TARGET> {
    private PojoFactory pojoFactory;
    private PojoDescriptorBuilder pojoDescriptorBuilder;
    private PojoDescriptorBuilderFactory pojoDescriptorBuilderFactory;

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.pojoDescriptorBuilder == null) {
            if (this.pojoDescriptorBuilderFactory == null) {
                this.pojoDescriptorBuilderFactory = PojoDescriptorBuilderFactoryImpl.getInstance();
            }
            this.pojoDescriptorBuilder = this.pojoDescriptorBuilderFactory.createPublicMethodDescriptorBuilder();
        }
        if (this.pojoFactory == null) {
            this.pojoFactory = new GuessingPojoFactory();
        }
    }

    @Override
    public <T extends TARGET> T convert(SOURCE value, Object valueSource, GenericType<T> targetType) throws ValueException {
        if (value == null) {
            return null;
        }
        Class<?> sourceClass = value.getClass();
        Class targetClass = targetType.getAssignmentClass();
        Object result = this.pojoFactory.newInstance(targetClass);
        PojoDescriptor sourceDescriptor = this.pojoDescriptorBuilder.getDescriptor(sourceClass);
        PojoDescriptor targetDescriptor = this.pojoDescriptorBuilder.getDescriptor(result.getClass());
        Collection propertyDescriptors = targetDescriptor.getPropertyDescriptors();
        for (PojoPropertyDescriptor targetPropertyDescriptor : propertyDescriptors) {
            PojoPropertyAccessorOneArg setter = (PojoPropertyAccessorOneArg)targetPropertyDescriptor.getAccessor((PojoPropertyAccessorMode)PojoPropertyAccessorOneArgMode.SET);
            if (setter == null) continue;
            try {
                PojoPropertyAccessorNonArg getter = (PojoPropertyAccessorNonArg)sourceDescriptor.getAccessor(targetPropertyDescriptor.getName(), (PojoPropertyAccessorMode)PojoPropertyAccessorNonArgMode.GET);
                if (getter == null) {
                    this.handleNoGetterForSetter(setter, targetClass, value, sourceClass);
                    continue;
                }
                Object sourcePropertyValue = getter.invoke(value);
                GenericType targetPropertyType = setter.getPropertyType();
                Object targetPropertyValue = this.getComposedValueConverter().convert(sourcePropertyValue, valueSource, targetPropertyType);
                setter.invoke(result, targetPropertyValue);
            }
            catch (Exception e) {
                throw new ValueConvertException((Throwable)e, value, targetType, valueSource);
            }
        }
        return (T)result;
    }

    protected void handleNoGetterForSetter(PojoPropertyAccessorOneArg setter, Class<?> targetClass, Object sourceObject, Class<?> sourceClass) {
        throw new PojoPropertyNotFoundException(sourceClass, setter.getName());
    }

    @Inject
    public void setPojoFactory(PojoFactory pojoFactory) {
        this.getInitializationState().requireNotInitilized();
        this.pojoFactory = pojoFactory;
    }

    protected PojoDescriptorBuilder getPojoDescriptorBuilder() {
        return this.pojoDescriptorBuilder;
    }

    public void setPojoDescriptorBuilder(PojoDescriptorBuilder pojoDescriptorBuilder) {
        this.getInitializationState().requireNotInitilized();
        this.pojoDescriptorBuilder = pojoDescriptorBuilder;
    }

    @Inject
    public void setPojoDescriptorBuilderFactory(PojoDescriptorBuilderFactory pojoDescriptorBuilderFactory) {
        this.getInitializationState().requireNotInitilized();
        this.pojoDescriptorBuilderFactory = pojoDescriptorBuilderFactory;
    }

    protected PojoDescriptorBuilderFactory getPojoDescriptorBuilderFactory() {
        return this.pojoDescriptorBuilderFactory;
    }
}

