/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.base;

import java.lang.reflect.Type;
import javax.inject.Inject;
import net.sf.mmm.util.exception.api.ValueNotSetException;
import net.sf.mmm.util.exception.api.WrongValueTypeException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.value.api.ComposedValueConverter;
import net.sf.mmm.util.value.base.AbstractGenericValueConverter;

public abstract class AbstractComposedValueConverter
extends AbstractGenericValueConverter<Object>
implements ComposedValueConverter {
    private ReflectionUtil reflectionUtil;

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
    }

    @Override
    public final Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    public final Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public final <T> T convert(Object value, Object valueSource, Class<T> targetClass) {
        return (T)this.convert(value, valueSource, this.getReflectionUtil().createGenericType(targetClass));
    }

    @Override
    public <TARGET> TARGET convertValue(Object value, Object valueSource, Class<TARGET> targetClass) throws ValueNotSetException, WrongValueTypeException {
        if (value == null) {
            throw new ValueNotSetException(valueSource);
        }
        TARGET result = this.convert(value, valueSource, (Class<T>)targetClass);
        if (result == null) {
            throw new WrongValueTypeException(value, valueSource, targetClass);
        }
        return result;
    }

    @Override
    public <TARGET> TARGET convertValue(Object value, Object valueSource, Class<TARGET> targetClass, Type targetType) throws ValueNotSetException, WrongValueTypeException {
        if (value == null) {
            throw new ValueNotSetException(valueSource);
        }
        GenericType genericType = this.getReflectionUtil().createGenericType(targetType);
        Object result = this.convert(value, valueSource, genericType);
        if (result == null) {
            throw new WrongValueTypeException(value, valueSource, targetClass);
        }
        return (TARGET)result;
    }
}

