/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.value.api;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;
import net.sf.mmm.util.lang.api.attribute.AttributeReadMaximumValue;
import net.sf.mmm.util.lang.api.attribute.AttributeReadMinimumValue;
import net.sf.mmm.util.lang.base.ComparableComparator;

public class Range<V>
implements Serializable,
AttributeReadMinimumValue<V>,
AttributeReadMaximumValue<V> {
    private static final long serialVersionUID = 6426261544538415827L;
    private V min;
    private V max;
    public static final String MIN_UNBOUND = "\u2212\u221e";
    public static final String MAX_UNBOUND = "+\u221e";

    protected Range() {
    }

    public Range(V min, V max) {
        int delta;
        if (min != null && max != null && (delta = this.getComparator().compare(min, max)) > 0) {
            throw new ValueOutOfRangeException(min, min, max);
        }
        this.min = min;
        this.max = max;
    }

    public V getMin() {
        return this.min;
    }

    public V getMax() {
        return this.max;
    }

    public V getMinimumValue() {
        return this.min;
    }

    public V getMaximumValue() {
        return this.max;
    }

    public Range<V> withMin(V minimum) {
        if (Objects.equals(this.min, minimum)) {
            return this;
        }
        return new Range<V>(minimum, this.max);
    }

    public Range<V> withMax(V maximum) {
        if (Objects.equals(this.max, maximum)) {
            return this;
        }
        return new Range<V>(this.min, maximum);
    }

    protected Comparator<? super V> getComparator() {
        return ComparableComparator.getInstance();
    }

    public boolean isContained(V value) {
        int delta;
        NlsNullPointerException.checkNotNull((String)"value", value);
        Comparator<V> comparator = this.getComparator();
        if (this.min != null && (delta = comparator.compare(value, this.min)) < 0) {
            return false;
        }
        return this.max == null || (delta = comparator.compare(value, this.max)) <= 0;
    }

    public void verifyContained(V value) throws ValueOutOfRangeException {
        if (!this.isContained(value)) {
            throw new ValueOutOfRangeException(null, value, this.min, this.max);
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (!Objects.equals(this.min, other.min)) {
            return false;
        }
        return Objects.equals(this.max, other.max);
    }

    public final int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.min == null) {
            buffer.append(MIN_UNBOUND);
        } else {
            buffer.append(this.min);
        }
        buffer.append(',');
        if (this.max == null) {
            buffer.append(MAX_UNBOUND);
        } else {
            buffer.append(this.max);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

