/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.text;

import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.validation.NlsBundleUtilValidationRoot;
import net.sf.mmm.util.validation.base.AbstractValueValidator;

public class ValidatorPattern
extends AbstractValueValidator<CharSequence> {
    public static final String CODE = "Pattern";
    private final Pattern pattern;

    public ValidatorPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public ValidatorPattern(String pattern) {
        this(Pattern.compile(pattern));
    }

    @Override
    protected String getCode() {
        return CODE;
    }

    @Override
    protected NlsMessage validateNotNull(CharSequence value) {
        boolean matches = this.pattern.matcher(value).matches();
        if (!matches) {
            return this.createBundle(NlsBundleUtilValidationRoot.class).errorValueFormat(null, this.pattern);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorPattern other = (ValidatorPattern)obj;
        return Objects.equals(this.pattern, other.pattern);
    }
}

