/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import net.sf.mmm.util.math.api.MathUtil;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.validation.base.AbstractValidatorRange;
import net.sf.mmm.util.validation.base.ValidatorArrayLength;
import net.sf.mmm.util.validation.base.ValidatorRange;
import net.sf.mmm.util.validation.base.ValidatorRangeGeneric;
import net.sf.mmm.util.validation.base.ValidatorRegistry;
import net.sf.mmm.util.validation.base.collection.ValidatorCollectionSize;
import net.sf.mmm.util.validation.base.collection.ValidatorMapSize;
import net.sf.mmm.util.value.api.NumberRange;
import net.sf.mmm.util.value.api.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintContext.class);
    private final ValidatorRegistry<?, ?> validatorRegistry;
    private final AnnotatedElement annotatedElement;
    private final GenericType<?> valueType;
    private final MathUtil mathUtil;
    private Annotation constraint;
    private NumberRange range;

    ConstraintContext(ValidatorRegistry<?, ?> validatorRegistry, AnnotatedElement annotatedElement, GenericType<?> valueType, MathUtil mathUtil) {
        this.validatorRegistry = validatorRegistry;
        this.annotatedElement = annotatedElement;
        this.valueType = valueType;
        this.mathUtil = mathUtil;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    public GenericType<?> getValueType() {
        return this.valueType;
    }

    void setConstraint(Annotation constraint) {
        this.constraint = constraint;
    }

    public void setMinimum(Number minimum) {
        if (this.range == null) {
            this.range = new NumberRange(minimum, null);
        } else {
            this.updateRange(this.range.withMin(minimum));
        }
    }

    public void setMaximum(Number maximum) {
        if (this.range == null) {
            this.range = new NumberRange(null, maximum);
        } else {
            this.updateRange(this.range.withMax(maximum));
        }
    }

    private void updateRange(NumberRange newRange) {
        if (this.range != newRange) {
            Number min = (Number)this.range.getMin();
            Number max = (Number)this.range.getMax();
            if (min != null && newRange.getMin() != min || max != null && newRange.getMax() != max) {
                LOG.warn("Replacing range {} with {} for constraint {} of {}.", new Object[]{this.range, newRange, this.constraint, this.annotatedElement});
            }
            this.range = newRange;
        }
    }

    void complete() {
        if (this.range != null) {
            AbstractValidatorRange validator = null;
            if (this.valueType != null) {
                Class valueClass = this.valueType.getAssignmentClass();
                if (this.valueType.isCollection()) {
                    validator = new ValidatorCollectionSize((Range<Number>)this.range);
                } else if (this.valueType.isMap()) {
                    validator = new ValidatorMapSize((Range<Number>)this.range);
                } else if (this.valueType.getComponentType() != null) {
                    validator = new ValidatorArrayLength((Range<Number>)this.range);
                } else if (this.mathUtil.getNumberType(valueClass) != null) {
                    validator = new ValidatorRange(this.range);
                }
            }
            if (validator == null) {
                validator = new ValidatorRangeGeneric(this.range);
            }
            this.validatorRegistry.add(validator);
        }
    }
}

