/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.math.api.MathUtil;
import net.sf.mmm.util.math.base.MathUtilImpl;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.validation.base.ValidatorRegistry;
import net.sf.mmm.util.validation.base.jsr303.BeanValidationProcessor;
import net.sf.mmm.util.validation.base.jsr303.ConstraintContext;
import net.sf.mmm.util.validation.base.jsr303.constraints.ConstraintProcessor;
import net.sf.mmm.util.validation.base.jsr303.constraints.TypedConstraintProcessor;

public abstract class AbstractBeanValidationProcessor
extends AbstractComponent
implements BeanValidationProcessor {
    private final Map<String, ConstraintProcessor<?>> annotation2ProcessorMap = new HashMap();
    private MathUtil mathUtil;

    @Inject
    public void setMathUtil(MathUtil mathUtil) {
        this.mathUtil = mathUtil;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.mathUtil == null) {
            this.mathUtil = MathUtilImpl.getInstance();
        }
    }

    protected final void registerProcessor(String annotationFqn, ConstraintProcessor<?> processor) {
        ConstraintProcessor<?> duplicate = this.annotation2ProcessorMap.put(annotationFqn, processor);
        if (duplicate != null) {
            throw new DuplicateObjectException(processor, (Object)annotationFqn, duplicate);
        }
    }

    protected final void registerProcessor(Class<? extends Annotation> annotationType, ConstraintProcessor<?> processor) {
        this.registerProcessor(annotationType.getName(), processor);
    }

    protected final void registerProcessor(TypedConstraintProcessor<?> processor) {
        this.registerProcessor(processor.getType(), processor);
    }

    @Override
    public void processConstraints(AnnotatedElement annotatedElement, ValidatorRegistry<?, ?> validatorRegistry, GenericType<?> valueType) {
        ConstraintContext context = null;
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            ConstraintProcessor<?> processor = this.annotation2ProcessorMap.get(annotationType.getName());
            if (processor == null) continue;
            if (context == null) {
                context = new ConstraintContext(validatorRegistry, annotatedElement, valueType, this.mathUtil);
            }
            context.setConstraint(annotation);
            processor.process(annotation, context);
        }
        if (context != null) {
            context.complete();
        }
    }
}

