/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.collection;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValueValidator;
import net.sf.mmm.util.validation.base.ValidationFailureComposer;

public class ValidatorMapValues<V>
extends AbstractValidator<Map<?, V>>
implements ComposedValueValidator<Map<?, V>> {
    private final AbstractValidator<? super V>[] validators;

    @SafeVarargs
    public ValidatorMapValues(AbstractValidator<? super V> ... validators) {
        this.validators = validators;
    }

    public ValidatorMapValues(List<AbstractValidator<? super V>> validators) {
        this(validators.toArray(new AbstractValidator[validators.size()]));
    }

    @Override
    public AbstractValidator<?> getValidator(int index) {
        return this.validators[index];
    }

    @Override
    public int getValidatorCount() {
        return this.validators.length;
    }

    @Override
    public ValidationFailure validate(Map<?, V> map, Object valueSource) {
        ValidationFailureComposer composer = new ValidationFailureComposer();
        if (map != null) {
            int i = 0;
            for (V value : map.values()) {
                for (AbstractValidator<V> abstractValidator : this.validators) {
                    String source = valueSource == null ? Integer.toString(i) : valueSource.toString() + "." + i;
                    ValidationFailure failure = abstractValidator.validate(value, source);
                    composer.add(failure);
                }
                ++i;
            }
        }
        return composer.get(valueSource);
    }

    @Override
    public int hashCode() {
        return 8643;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorMapValues other = (ValidatorMapValues)obj;
        return Objects.equals(this.validators, other.validators);
    }
}

