/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.collection;

import java.util.Map;
import java.util.function.BiFunction;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComplexValidatorBuilder;
import net.sf.mmm.util.validation.base.ObjectValidatorBuilder;
import net.sf.mmm.util.validation.base.ObjectValidatorBuilderFactory;
import net.sf.mmm.util.validation.base.collection.ValidatorMapKeys;
import net.sf.mmm.util.validation.base.collection.ValidatorMapSize;
import net.sf.mmm.util.value.api.Range;

public abstract class AbstractMapValidatorBuilder<K, V, M extends Map<K, V>, PARENT, SELF extends AbstractMapValidatorBuilder<K, V, M, PARENT, SELF>>
extends ComplexValidatorBuilder<M, PARENT, SELF> {
    private ObjectValidatorBuilder<K, ? extends SELF, ?> keySubBuilder;
    private ObjectValidatorBuilder<V, ? extends SELF, ?> valueSubBuilder;

    public AbstractMapValidatorBuilder(PARENT parent) {
        super(parent);
    }

    public SELF size(Range<Number> range) {
        return (SELF)((AbstractMapValidatorBuilder)this.add((AbstractValidator)new ValidatorMapSize(range)));
    }

    public SELF size(int min, int max) {
        return this.size((Range<Number>)new Range((Object)min, (Object)max));
    }

    public SELF max(int max) {
        return this.size(0, max);
    }

    public <SUB extends ObjectValidatorBuilder<K, ? extends SELF, ?>> SUB withKeys(BiFunction<ObjectValidatorBuilderFactory<SELF>, K, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.keySubBuilder != null) {
            throw new IllegalStateException("keySubBuilder already exists!");
        }
        this.keySubBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    public <SUB extends ObjectValidatorBuilder<V, ? extends SELF, ?>> SUB withValues(BiFunction<ObjectValidatorBuilderFactory<SELF>, V, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.valueSubBuilder != null) {
            throw new IllegalStateException("valueSubBuilder already exists!");
        }
        this.valueSubBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    @Override
    public AbstractValidator<? super M> build() {
        if (this.keySubBuilder != null) {
            this.add((AbstractValidator)new ValidatorMapKeys(this.getValidators(this.keySubBuilder)));
        }
        if (this.valueSubBuilder != null) {
            this.add((AbstractValidator)new ValidatorMapKeys(this.getValidators(this.valueSubBuilder)));
        }
        return super.build();
    }
}

