/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.collection;

import java.util.Collection;
import java.util.function.BiFunction;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComplexValidatorBuilder;
import net.sf.mmm.util.validation.base.ObjectValidatorBuilder;
import net.sf.mmm.util.validation.base.ObjectValidatorBuilderFactory;
import net.sf.mmm.util.validation.base.collection.ValidatorCollectionElements;
import net.sf.mmm.util.validation.base.collection.ValidatorCollectionSize;
import net.sf.mmm.util.value.api.Range;

public abstract class AbstractCollectionValidatorBuilder<E, V extends Collection<E>, PARENT, SELF extends AbstractCollectionValidatorBuilder<E, V, PARENT, SELF>>
extends ComplexValidatorBuilder<V, PARENT, SELF> {
    private ObjectValidatorBuilder<E, ? extends SELF, ?> subBuilder;

    public AbstractCollectionValidatorBuilder(PARENT parent) {
        super(parent);
    }

    public SELF size(Range<Number> range) {
        return (SELF)((AbstractCollectionValidatorBuilder)this.add((AbstractValidator)new ValidatorCollectionSize(range)));
    }

    public SELF size(int min, int max) {
        return this.size((Range<Number>)new Range((Object)min, (Object)max));
    }

    public SELF max(int max) {
        return this.size(0, max);
    }

    public <SUB extends ObjectValidatorBuilder<E, ? extends SELF, ?>> SUB with(BiFunction<ObjectValidatorBuilderFactory<SELF>, E, SUB> factory) {
        ObjectValidatorBuilder sub;
        if (this.subBuilder != null) {
            throw new IllegalStateException("subBuilder already exists!");
        }
        this.subBuilder = sub = (ObjectValidatorBuilder)factory.apply(this.getSubFactory(), null);
        return (SUB)sub;
    }

    @Override
    public AbstractValidator<? super V> build() {
        if (this.subBuilder != null) {
            this.add((AbstractValidator)new ValidatorCollectionElements(this.getValidators(this.subBuilder)));
        }
        return super.build();
    }
}

