/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.Objects;
import net.sf.mmm.util.lang.api.CompareOperator;
import net.sf.mmm.util.lang.api.GenericBean;
import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.validation.NlsBundleUtilValidationRoot;
import net.sf.mmm.util.validation.base.AbstractValueValidator;

public class ValidatorCompare<V extends Comparable<V>>
extends AbstractValueValidator<V> {
    private final CompareOperator comparator;
    private final AttributeReadValue<V> valueSource;
    private final String source;
    private final boolean dynamic;

    public ValidatorCompare(CompareOperator comparator, AttributeReadValue<V> valueSource, String source) {
        this.comparator = comparator;
        this.valueSource = valueSource;
        this.dynamic = true;
        this.source = source;
    }

    public ValidatorCompare(CompareOperator comparator, V value) {
        this.comparator = comparator;
        this.valueSource = new GenericBean(value);
        this.dynamic = false;
        this.source = null;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    protected NlsMessage validateNotNull(V value) {
        Comparable value2 = (Comparable)this.valueSource.getValue();
        if (this.comparator.eval(value, (Object)value2)) {
            return null;
        }
        if (this.source == null) {
            return this.createBundle(NlsBundleUtilValidationRoot.class).errorValueComparison(value, this.comparator, value2);
        }
        return this.createBundle(NlsBundleUtilValidationRoot.class).errorValueComparisonWithSource(value, this.comparator, value2, this.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.comparator, this.valueSource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorCompare other = (ValidatorCompare)obj;
        if (!Objects.equals(this.comparator, other.comparator)) {
            return false;
        }
        return Objects.equals(this.valueSource, other.valueSource);
    }
}

