/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.Objects;
import net.sf.mmm.util.pojo.api.TypedProperty;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValueValidator;
import net.sf.mmm.util.validation.base.ValidationFailureComposer;

public class ComposedValidator<V>
extends AbstractValidator<V>
implements ComposedValueValidator<V> {
    public static final String CODE = "ComposedValidator";
    private final AbstractValidator<? super V>[] validators;

    @SafeVarargs
    public ComposedValidator(AbstractValidator<? super V> ... validators) {
        this.validators = validators;
    }

    @Override
    protected String getCode() {
        return CODE;
    }

    @Override
    public ValidationFailure validate(V value, Object valueSource) {
        ValidationFailureComposer composer = new ValidationFailureComposer();
        for (AbstractValidator<V> abstractValidator : this.validators) {
            ValidationFailure failure = abstractValidator.validate(value, valueSource);
            composer.add(failure);
        }
        return composer.get(valueSource);
    }

    @Override
    public int getValidatorCount() {
        return this.validators.length;
    }

    @Override
    public AbstractValidator<? super V> getValidator(int index) {
        return this.validators[index];
    }

    @Override
    public <P> P getProperty(TypedProperty<P> property) {
        AbstractValidator<V> validator;
        P value = null;
        AbstractValidator<? super V>[] abstractValidatorArray = this.validators;
        int n = abstractValidatorArray.length;
        for (int i = 0; i < n && (value = (P)(validator = abstractValidatorArray[i]).getProperty(property)) == null; ++i) {
        }
        return value;
    }

    @Override
    public boolean contains(AbstractValidator<?> validator) {
        if (super.contains(validator)) {
            return true;
        }
        for (AbstractValidator<V> abstractValidator : this.validators) {
            if (!abstractValidator.contains(validator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ComposedValidator<V> append(AbstractValidator<? super V> ... additionalValidators) {
        Objects.requireNonNull(additionalValidators, "validators");
        if (additionalValidators.length == 0) {
            return this;
        }
        AbstractValidator[] composed = new AbstractValidator[this.validators.length + additionalValidators.length];
        System.arraycopy(this.validators, 0, composed, 0, this.validators.length);
        System.arraycopy(additionalValidators, 0, composed, this.validators.length, additionalValidators.length);
        return new ComposedValidator<V>(composed);
    }

    @Override
    public int hashCode() {
        return 97531;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposedValidator other = (ComposedValidator)obj;
        return Objects.equals(this.validators, other.validators);
    }
}

