/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.Objects;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.pojo.api.TypedProperty;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.api.ValueValidator;
import net.sf.mmm.util.validation.base.ComposedValidator;
import net.sf.mmm.util.validation.base.ValidatorNone;

public abstract class AbstractValidator<V>
implements ValueValidator<V> {
    public static final TypedProperty<Boolean> PROPERTY_MANDATORY = new TypedProperty(Boolean.class, "mandatory");
    public static final TypedProperty<Comparable> PROPERTY_MINIMUM = new TypedProperty(Comparable.class, "min");
    public static final TypedProperty<Comparable> PROPERTY_MAXIMUM = new TypedProperty(Comparable.class, "max");

    protected String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final ValidationFailure validate(V value) {
        return this.validate(value, null);
    }

    public boolean isDynamic() {
        return false;
    }

    public final boolean isMandatory() {
        Boolean mandatory = this.getProperty(PROPERTY_MANDATORY);
        return Boolean.TRUE.equals(mandatory);
    }

    protected <BUNDLE extends NlsBundle> BUNDLE createBundle(Class<BUNDLE> bundleInterface) {
        return (BUNDLE)NlsAccess.getBundleFactory().createBundle(bundleInterface);
    }

    public <P> P getProperty(TypedProperty<P> property) {
        return null;
    }

    public boolean contains(AbstractValidator<?> validator) {
        return this.equals(validator);
    }

    public AbstractValidator<V> append(AbstractValidator<? super V> ... validators) {
        Objects.requireNonNull(validators, "validators");
        if (validators.length == 0) {
            return this;
        }
        if (validators.length == 1) {
            if (validators[0] == ValidatorNone.getInstance()) {
                return this;
            }
            return new ComposedValidator(this, validators[0]);
        }
        AbstractValidator[] array = new AbstractValidator[validators.length + 1];
        array[0] = this;
        System.arraycopy(validators, 0, validators, 1, validators.length);
        return new ComposedValidator(array);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

