/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.text.api.DiacriticalMark;
import net.sf.mmm.util.text.api.UnicodeUtil;
import org.slf4j.LoggerFactory;

public class UnicodeUtilImpl
extends AbstractComponent
implements UnicodeUtil {
    private static UnicodeUtil instance;
    private static final Map<Character, String> CHARACTER_TO_ASCII_MAP;
    private static final Map<Character, String> TRANSLITERATION_MAP;

    private static void initIso9(Map<Character, String> map) {
        map.put(Character.valueOf('\u0410'), "A");
        map.put(Character.valueOf('\u04d0'), Character.toString('\u0102'));
        map.put(Character.valueOf('\u04d2'), Character.toString('\u00c4'));
        map.put(Character.valueOf('\u04d8'), "A\u030b");
        map.put(Character.valueOf('\u0411'), "B");
        map.put(Character.valueOf('\u0412'), "V");
        map.put(Character.valueOf('\u0413'), "G");
        map.put(Character.valueOf('\u0490'), "G\u0300");
        map.put(Character.valueOf('\u0494'), Character.toString('\u011e'));
        map.put(Character.valueOf('\u0492'), Character.toString('\u0120'));
        map.put(Character.valueOf('\u0414'), "D");
        map.put(Character.valueOf('\u0402'), Character.toString('\u0110'));
        map.put(Character.valueOf('\u0403'), Character.toString('\u01f4'));
        map.put(Character.valueOf('\u0415'), "E");
        map.put(Character.valueOf('\u04d6'), Character.toString('\u0114'));
        map.put(Character.valueOf('\u0401'), Character.toString('\u00cb'));
        map.put(Character.valueOf('\u0404'), Character.toString('\u00ca'));
        map.put(Character.valueOf('\u04bc'), "C\u0306");
        map.put(Character.valueOf('\u04be'), Character.toString('\u00c7') + '\u0306');
        map.put(Character.valueOf('\u0416'), Character.toString('\u017d'));
        map.put(Character.valueOf('\u04c1'), "Z\u0306");
        map.put(Character.valueOf('\u04dc'), "Z\u0304");
        map.put(Character.valueOf('\u0496'), Character.toString('\u017d') + '\u0327');
        map.put(Character.valueOf('\u0417'), "Z");
        map.put(Character.valueOf('\u04de'), "Z\u0308");
        map.put(Character.valueOf('\u0405'), Character.toString('\u1e90'));
        map.put(Character.valueOf('\u04e0'), Character.toString('\u0179'));
        map.put(Character.valueOf('\u0418'), "I");
        map.put(Character.valueOf('\u04e4'), Character.toString('\u00ce'));
        map.put(Character.valueOf('\u0406'), Character.toString('\u00cc'));
        map.put(Character.valueOf('\u0407'), Character.toString('\u00cf'));
        map.put(Character.valueOf('\u0419'), "J");
        map.put(Character.valueOf('\u0408'), "J\u030c");
        map.put(Character.valueOf('\u041a'), "K");
        map.put(Character.valueOf('\u049a'), Character.toString('\u0136'));
        map.put(Character.valueOf('\u049e'), "K\u0304");
        map.put(Character.valueOf('\u041b'), "L");
        map.put(Character.valueOf('\u0409'), "L\u0302");
        map.put(Character.valueOf('\u041c'), "M");
        map.put(Character.valueOf('\u041d'), "N");
        map.put(Character.valueOf('\u040a'), "N\u0302");
        map.put(Character.valueOf('\u04a4'), Character.toString('\u1e44'));
        map.put(Character.valueOf('\u04a2'), Character.toString('\u1e46'));
        map.put(Character.valueOf('\u04a2'), Character.toString('\u1e46'));
        map.put(Character.valueOf('\u041e'), "O");
        map.put(Character.valueOf('\u04e6'), Character.toString('\u00d6'));
        map.put(Character.valueOf('\u04e8'), Character.toString('\u00d4'));
        map.put(Character.valueOf('\u041f'), "P");
        map.put(Character.valueOf('\u04a6'), Character.toString('\u1e54'));
        map.put(Character.valueOf('\u0420'), "R");
        map.put(Character.valueOf('\u0421'), "S");
        map.put(Character.valueOf('\u04aa'), Character.toString('\u00c7'));
        map.put(Character.valueOf('\u04aa'), Character.toString('\u00c7'));
        map.put(Character.valueOf('\u0422'), "T");
        map.put(Character.valueOf('\u04ac'), Character.toString('\u0162'));
        map.put(Character.valueOf('\u040b'), Character.toString('\u0106'));
        map.put(Character.valueOf('\u040c'), Character.toString('\u1e30'));
        map.put(Character.valueOf('\u0423'), "U");
        map.put(Character.valueOf('\u040e'), Character.toString('\u016c'));
        map.put(Character.valueOf('\u04f0'), Character.toString('\u00dc'));
        map.put(Character.valueOf('\u04f2'), Character.toString('\u0170'));
        map.put(Character.valueOf('\u04ae'), Character.toString('\u00d9'));
        map.put(Character.valueOf('\u0424'), "F");
        map.put(Character.valueOf('\u0425'), "H");
        map.put(Character.valueOf('\u04b2'), Character.toString('\u1e28'));
        map.put(Character.valueOf('\u04ba'), Character.toString('\u1e28'));
        map.put(Character.valueOf('\u0426'), "C");
        map.put(Character.valueOf('\u04b4'), "C\u0304");
        map.put(Character.valueOf('\u0427'), Character.toString('\u010c'));
        map.put(Character.valueOf('\u04f4'), "C\u0308");
        map.put(Character.valueOf('\u04cb'), Character.toString('\u00c7'));
        map.put(Character.valueOf('\u040f'), "D\u0302");
        map.put(Character.valueOf('\u0428'), Character.toString('\u0160'));
        map.put(Character.valueOf('\u0429'), Character.toString('\u015c'));
        map.put(Character.valueOf('\u042a'), Character.toString('\u02ba'));
        map.put(Character.valueOf('\u042b'), "Y");
        map.put(Character.valueOf('\u04f8'), Character.toString('\u0178'));
        map.put(Character.valueOf('\u04f8'), Character.toString('\u0178'));
        map.put(Character.valueOf('\u042c'), Character.toString('\u02b9'));
        map.put(Character.valueOf('\u042d'), Character.toString('\u00c8'));
        map.put(Character.valueOf('\u042e'), Character.toString('\u00db'));
        map.put(Character.valueOf('\u042f'), Character.toString('\u00c2'));
        map.put(Character.valueOf('\u048c'), Character.toString('\u011a'));
        map.put(Character.valueOf('\u046a'), Character.toString('\u01cd'));
        map.put(Character.valueOf('\u0472'), "F\u0300");
        map.put(Character.valueOf('\u0474'), Character.toString('\u1ef2'));
        map.put(Character.valueOf('\u04a8'), Character.toString('\u00d2'));
        map.put(Character.valueOf('\u0430'), "a");
        map.put(Character.valueOf('\u04d1'), Character.toString('\u0103'));
        map.put(Character.valueOf('\u04d3'), Character.toString('\u00e4'));
        map.put(Character.valueOf('\u04d9'), "a\u030b");
        map.put(Character.valueOf('\u0431'), "b");
        map.put(Character.valueOf('\u0432'), "v");
        map.put(Character.valueOf('\u0433'), "g");
        map.put(Character.valueOf('\u0491'), "g\u0300");
        map.put(Character.valueOf('\u0495'), Character.toString('\u011f'));
        map.put(Character.valueOf('\u0493'), Character.toString('\u0121'));
        map.put(Character.valueOf('\u0434'), "d");
        map.put(Character.valueOf('\u0452'), Character.toString('\u0111'));
        map.put(Character.valueOf('\u0453'), Character.toString('\u01f5'));
        map.put(Character.valueOf('\u0435'), "e");
        map.put(Character.valueOf('\u04d7'), Character.toString('\u0115'));
        map.put(Character.valueOf('\u0451'), Character.toString('\u00eb'));
        map.put(Character.valueOf('\u0454'), Character.toString('\u00ea'));
        map.put(Character.valueOf('\u04bd'), "c\u0306");
        map.put(Character.valueOf('\u04bf'), Character.toString('\u00e7') + '\u0306');
        map.put(Character.valueOf('\u0436'), Character.toString('\u017e'));
        map.put(Character.valueOf('\u04c2'), "z\u0306");
        map.put(Character.valueOf('\u04dd'), "z\u0304");
        map.put(Character.valueOf('\u0497'), Character.toString('\u017e') + '\u0327');
        map.put(Character.valueOf('\u0437'), "z");
        map.put(Character.valueOf('\u04df'), "z\u0308");
        map.put(Character.valueOf('\u0455'), Character.toString('\u1e91'));
        map.put(Character.valueOf('\u04e1'), Character.toString('\u017a'));
        map.put(Character.valueOf('\u0438'), "i");
        map.put(Character.valueOf('\u04e5'), Character.toString('\u00ee'));
        map.put(Character.valueOf('\u0456'), Character.toString('\u00ec'));
        map.put(Character.valueOf('\u0457'), Character.toString('\u00ef'));
        map.put(Character.valueOf('\u0439'), "j");
        map.put(Character.valueOf('\u0458'), "j\u030c");
        map.put(Character.valueOf('\u043a'), "k");
        map.put(Character.valueOf('\u049b'), Character.toString('\u0137'));
        map.put(Character.valueOf('\u049f'), "k\u0304");
        map.put(Character.valueOf('\u043b'), "l");
        map.put(Character.valueOf('\u0459'), "l\u0302");
        map.put(Character.valueOf('\u043c'), "m");
        map.put(Character.valueOf('\u043d'), "n");
        map.put(Character.valueOf('\u045a'), "n\u0302");
        map.put(Character.valueOf('\u04a5'), Character.toString('\u1e45'));
        map.put(Character.valueOf('\u04a3'), Character.toString('\u1e47'));
        map.put(Character.valueOf('\u04a3'), Character.toString('\u1e47'));
        map.put(Character.valueOf('\u043e'), "o");
        map.put(Character.valueOf('\u04e7'), Character.toString('\u00f6'));
        map.put(Character.valueOf('\u04e9'), Character.toString('\u00f4'));
        map.put(Character.valueOf('\u043f'), "p");
        map.put(Character.valueOf('\u04a7'), Character.toString('\u1e55'));
        map.put(Character.valueOf('\u0440'), "r");
        map.put(Character.valueOf('\u0441'), "s");
        map.put(Character.valueOf('\u04ab'), Character.toString('\u00e7'));
        map.put(Character.valueOf('\u04ab'), Character.toString('\u00e7'));
        map.put(Character.valueOf('\u0442'), "t");
        map.put(Character.valueOf('\u04ad'), Character.toString('\u0163'));
        map.put(Character.valueOf('\u045b'), Character.toString('\u0107'));
        map.put(Character.valueOf('\u045c'), Character.toString('\u1e31'));
        map.put(Character.valueOf('\u0443'), "u");
        map.put(Character.valueOf('\u045e'), Character.toString('\u016d'));
        map.put(Character.valueOf('\u04f1'), Character.toString('\u00fc'));
        map.put(Character.valueOf('\u04f3'), Character.toString('\u0171'));
        map.put(Character.valueOf('\u04af'), Character.toString('\u00f9'));
        map.put(Character.valueOf('\u0444'), "f");
        map.put(Character.valueOf('\u0445'), "h");
        map.put(Character.valueOf('\u04b3'), Character.toString('\u1e29'));
        map.put(Character.valueOf('\u04bb'), Character.toString('\u1e29'));
        map.put(Character.valueOf('\u0446'), "c");
        map.put(Character.valueOf('\u04b5'), "c\u0304");
        map.put(Character.valueOf('\u0447'), Character.toString('\u010d'));
        map.put(Character.valueOf('\u04f5'), "c\u0308");
        map.put(Character.valueOf('\u04cc'), Character.toString('\u00e7'));
        map.put(Character.valueOf('\u045f'), "d\u0302");
        map.put(Character.valueOf('\u0448'), Character.toString('\u0161'));
        map.put(Character.valueOf('\u0449'), Character.toString('\u015d'));
        map.put(Character.valueOf('\u044a'), Character.toString('\u02ba'));
        map.put(Character.valueOf('\u044b'), "y");
        map.put(Character.valueOf('\u04f9'), Character.toString('\u00ff'));
        map.put(Character.valueOf('\u04f9'), Character.toString('\u00ff'));
        map.put(Character.valueOf('\u044c'), Character.toString('\u02b9'));
        map.put(Character.valueOf('\u044d'), Character.toString('\u00e8'));
        map.put(Character.valueOf('\u044e'), Character.toString('\u00fb'));
        map.put(Character.valueOf('\u044f'), Character.toString('\u00e2'));
        map.put(Character.valueOf('\u048d'), Character.toString('\u011b'));
        map.put(Character.valueOf('\u046b'), Character.toString('\u01ce'));
        map.put(Character.valueOf('\u0473'), "f\u0300");
        map.put(Character.valueOf('\u0475'), Character.toString('\u1ef3'));
        map.put(Character.valueOf('\u04a9'), Character.toString('\u00f2'));
        map.put(Character.valueOf('\u2035'), Character.toString('\u2019'));
        map.put(Character.valueOf('\u04c0'), Character.toString('\u2021'));
    }

    private static void initIso843(Map<Character, String> map) {
        map.put(Character.valueOf('\u0391'), "A");
        map.put(Character.valueOf('\u0392'), "B");
        map.put(Character.valueOf('\u0393'), "G");
        map.put(Character.valueOf('\u0394'), "D");
        map.put(Character.valueOf('\u0395'), "E");
        map.put(Character.valueOf('\u0396'), "Z");
        map.put(Character.valueOf('\u0397'), Character.toString('\u0112'));
        map.put(Character.valueOf('\u0398'), "Th");
        map.put(Character.valueOf('\u0399'), "I");
        map.put(Character.valueOf('\u039a'), "K");
        map.put(Character.valueOf('\u039b'), "L");
        map.put(Character.valueOf('\u039c'), "M");
        map.put(Character.valueOf('\u039d'), "N");
        map.put(Character.valueOf('\u039e'), "X");
        map.put(Character.valueOf('\u039f'), "O");
        map.put(Character.valueOf('\u03a0'), "P");
        map.put(Character.valueOf('\u03a1'), "R");
        map.put(Character.valueOf('\u03a3'), "S");
        map.put(Character.valueOf('\u03a4'), "T");
        map.put(Character.valueOf('\u03a5'), "Y");
        map.put(Character.valueOf('\u03a6'), "F");
        map.put(Character.valueOf('\u03a7'), "Ch");
        map.put(Character.valueOf('\u03a8'), "Ps");
        map.put(Character.valueOf('\u03a9'), Character.toString('\u014c'));
        map.put(Character.valueOf('\u03dc'), "F");
        map.put(Character.valueOf('\u0370'), "H");
        map.put(Character.valueOf('\u039a'), "Q");
        map.put(Character.valueOf('\u03fa'), "S");
        map.put(Character.valueOf('\u03e0'), "Ss");
        map.put(Character.valueOf('\u03b1'), "a");
        map.put(Character.valueOf('\u03b2'), "b");
        map.put(Character.valueOf('\u03b3'), "g");
        map.put(Character.valueOf('\u03b4'), "d");
        map.put(Character.valueOf('\u03b5'), "e");
        map.put(Character.valueOf('\u03b6'), "z");
        map.put(Character.valueOf('\u03b7'), Character.toString('\u0113'));
        map.put(Character.valueOf('\u03ae'), Character.toString('\u1e17'));
        map.put(Character.valueOf('\u03b8'), "th");
        map.put(Character.valueOf('\u03b9'), "i");
        map.put(Character.valueOf('\u03af'), Character.toString('\u00ed'));
        map.put(Character.valueOf('\u03ba'), "k");
        map.put(Character.valueOf('\u03bb'), "l");
        map.put(Character.valueOf('\u03bc'), "m");
        map.put(Character.valueOf('\u03bd'), "n");
        map.put(Character.valueOf('\u03be'), "x");
        map.put(Character.valueOf('\u03bf'), "o");
        map.put(Character.valueOf('\u03c0'), "p");
        map.put(Character.valueOf('\u03c1'), "r");
        map.put(Character.valueOf('\u03c3'), "s");
        map.put(Character.valueOf('\u03c4'), "t");
        map.put(Character.valueOf('\u03c5'), "y");
        map.put(Character.valueOf('\u03c6'), "f");
        map.put(Character.valueOf('\u03c7'), "ch");
        map.put(Character.valueOf('\u03c8'), "ps");
        map.put(Character.valueOf('\u03c9'), Character.toString('\u014d'));
        map.put(Character.valueOf('\u03dd'), "f");
        map.put(Character.valueOf('\u0371'), "h");
        map.put(Character.valueOf('\u03df'), "q");
        map.put(Character.valueOf('\u03fb'), "s");
        map.put(Character.valueOf('\u03e1'), "ss");
    }

    protected void doInitialized() {
        super.doInitialized();
        instance = this;
    }

    @Override
    public String normalize2Ascii(char character) {
        return this.normalize2Ascii(character, '?');
    }

    public String normalize2Ascii(char character, char nonNormalizableCharaterReplacement) {
        String transliteration = this.transliterate(character);
        if (transliteration == null) {
            return CHARACTER_TO_ASCII_MAP.get(Character.valueOf(character));
        }
        int length = transliteration.length();
        if (length == 1) {
            return CHARACTER_TO_ASCII_MAP.get(Character.valueOf(transliteration.charAt(0)));
        }
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = transliteration.charAt(i);
            if (c <= '\u007f') {
                buffer.append(c);
                continue;
            }
            String ascii = CHARACTER_TO_ASCII_MAP.get(Character.valueOf(c));
            if (ascii != null) {
                buffer.append(ascii);
                continue;
            }
            if (nonNormalizableCharaterReplacement == '\u0000') continue;
            buffer.append(nonNormalizableCharaterReplacement);
        }
        return buffer.toString();
    }

    @Override
    public String transliterate(char character) {
        return TRANSLITERATION_MAP.get(Character.valueOf(character));
    }

    @Override
    public String transliterate(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            String translit = this.transliterate(c);
            if (translit != null) {
                buffer.append(translit);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public String normalize2Ascii(CharSequence text) {
        return this.normalize2Ascii(text, '?');
    }

    @Override
    public String normalize2Ascii(CharSequence text, char nonNormalizableCharaterReplacement) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length + 4);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c <= '\u007f') {
                buffer.append(c);
                continue;
            }
            String ascii = this.normalize2Ascii(c, nonNormalizableCharaterReplacement);
            if (ascii != null) {
                buffer.append(ascii);
                continue;
            }
            if (nonNormalizableCharaterReplacement == '\u0000') continue;
            buffer.append(nonNormalizableCharaterReplacement);
        }
        return buffer.toString();
    }

    @Override
    public boolean isDash(char character) {
        if (character == '-') {
            return true;
        }
        if (character == '\u2013') {
            return true;
        }
        if (character == '\u2014') {
            return true;
        }
        if (character == '\u2012') {
            return true;
        }
        if (character == '\u2053') {
            return true;
        }
        return character == '\u2015';
    }

    @Override
    public boolean isHyphen(char character) {
        if (character == '-') {
            return true;
        }
        if (character == '\u2010') {
            return true;
        }
        if (character == '\u2043') {
            return true;
        }
        return character == '\u2027';
    }

    @Override
    public boolean isMinus(char character) {
        if (character == '-') {
            return true;
        }
        return character == '\u2212';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UnicodeUtil getInstance() {
        if (instance != null) return instance;
        Class<UnicodeUtilImpl> clazz = UnicodeUtilImpl.class;
        synchronized (UnicodeUtilImpl.class) {
            if (instance != null) return instance;
            new UnicodeUtilImpl().initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static {
        CHARACTER_TO_ASCII_MAP = new HashMap<Character, String>();
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00a0'), " ");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00ad'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2212'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2013'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2014'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2012'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2053'), "~");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u2015'), "-");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u0237'), "j");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00df'), "ss");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00e4'), "ae");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00f6'), "oe");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00fc'), "ue");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00c4'), "Ae");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00d6'), "Oe");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u00dc'), "Ue");
        TRANSLITERATION_MAP = new HashMap<Character, String>();
        UnicodeUtilImpl.initIso9(TRANSLITERATION_MAP);
        UnicodeUtilImpl.initIso843(TRANSLITERATION_MAP);
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u266d'), "b");
        CHARACTER_TO_ASCII_MAP.put(Character.valueOf('\u266f'), "#");
        for (DiacriticalMark mark : DiacriticalMark.values()) {
            for (char composed : mark.getComposedCharacters()) {
                if (CHARACTER_TO_ASCII_MAP.containsKey(Character.valueOf(composed))) continue;
                Character decomposed = mark.decompose(composed);
                if (decomposed == null) {
                    LoggerFactory.getLogger(UnicodeUtilImpl.class).error("Illegal diacritic '" + (Object)((Object)mark) + "' could NOT decomposed '" + composed + "'!");
                    continue;
                }
                char normalized = decomposed.charValue();
                String ascii = null;
                while (ascii == null) {
                    ascii = CharFilter.ASCII_LETTER_FILTER.accept(normalized) ? Character.toString(normalized) : CHARACTER_TO_ASCII_MAP.get(decomposed);
                    if (ascii != null) continue;
                    boolean decomposeFailed2Ascii = true;
                    for (DiacriticalMark subMark : DiacriticalMark.values()) {
                        decomposed = subMark.decompose(normalized);
                        if (decomposed == null) continue;
                        normalized = decomposed.charValue();
                        decomposeFailed2Ascii = false;
                        break;
                    }
                    if (!decomposeFailed2Ascii) continue;
                    LoggerFactory.getLogger(UnicodeUtilImpl.class).debug("Decomposed form '" + normalized + "' is not ASCII!");
                    break;
                }
                if (ascii == null) continue;
                CHARACTER_TO_ASCII_MAP.put(Character.valueOf(composed), ascii);
            }
        }
    }
}

