/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import net.sf.mmm.util.lang.api.BasicHelper;
import net.sf.mmm.util.text.base.TransformerRule;

public class SuffixTransformerRule
extends TransformerRule {
    private final String sourceSuffix;
    private final String destinationSuffix;

    public SuffixTransformerRule(String sourceSuffix, String destinationSuffix) {
        this.sourceSuffix = sourceSuffix;
        this.destinationSuffix = destinationSuffix;
    }

    @Override
    public String transform(String string, String stringLowerCase) {
        if (stringLowerCase.endsWith(this.sourceSuffix)) {
            return SuffixTransformerRule.replaceSuffixWithCase(string, this.sourceSuffix.length(), this.destinationSuffix);
        }
        return null;
    }

    private static String replaceSuffixWithCase(String string, int suffixLength, String newSuffixLowerCase) {
        int stringLength = string.length();
        int newSuffixLength = newSuffixLowerCase.length();
        int replaceIndex = stringLength - suffixLength;
        if (replaceIndex < 0) {
            replaceIndex = 0;
        }
        StringBuilder result = new StringBuilder(replaceIndex + newSuffixLength);
        if (replaceIndex > 0) {
            result.append(string.substring(0, replaceIndex));
        }
        if (suffixLength > 0) {
            char c = string.charAt(replaceIndex);
            if (c == Character.toLowerCase(c)) {
                result.append(newSuffixLowerCase);
            } else if (suffixLength > 1) {
                c = string.charAt(replaceIndex + 1);
                if (c == Character.toLowerCase(c)) {
                    String first = newSuffixLowerCase.substring(0, 1);
                    String capital = BasicHelper.toUpperCase((String)first);
                    if (capital.length() == 1) {
                        result.append(newSuffixLowerCase);
                        result.setCharAt(replaceIndex, capital.charAt(0));
                    } else {
                        result.append(capital);
                        result.append(newSuffixLowerCase.substring(1));
                    }
                } else {
                    result.append(BasicHelper.toUpperCase((String)newSuffixLowerCase));
                }
            }
        }
        return result.toString();
    }
}

