/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.io.IOException;
import net.sf.mmm.util.lang.api.HorizontalAlignment;
import net.sf.mmm.util.text.api.Justification;

public class JustificationImpl
implements Justification {
    private static final char MODE_TRUNCATE = '|';
    private static final char MODE_DEFAULT = '\u0000';
    private static final String FORMAT_PATTERN = ".[-+~][0-9]+[|]?";
    private final HorizontalAlignment alignment;
    private final char filler;
    private final int width;
    private final char mode;

    public JustificationImpl(String format) {
        if (format.length() < 2) {
            this.illegalFormat(format);
        }
        this.filler = format.charAt(0);
        this.alignment = HorizontalAlignment.fromValue((String)Character.toString(format.charAt(1)));
        if (this.alignment == null) {
            this.illegalFormat(format);
        }
        int endIndex = format.length();
        char modeChar = format.charAt(format.length() - 1);
        if (modeChar >= '0' && modeChar <= '9') {
            this.mode = '\u0000';
        } else {
            this.mode = modeChar;
            --endIndex;
            if (this.mode != '|') {
                this.illegalFormat(format);
            }
        }
        this.width = Integer.parseInt(format.substring(2, endIndex));
    }

    private void illegalFormat(String format) {
        throw new IllegalArgumentException("Illegal format '" + format + "' - has to match " + FORMAT_PATTERN);
    }

    @Override
    public String justify(CharSequence value) {
        try {
            StringBuilder sb = new StringBuilder();
            this.justify(value, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void justify(CharSequence value, Appendable target) throws IOException {
        int i;
        int space = this.width - value.length();
        int leftSpace = 0;
        int rightSpace = 0;
        if (space > 0) {
            switch (this.alignment) {
                case CENTER: {
                    leftSpace = space / 2;
                    rightSpace = space - leftSpace;
                    break;
                }
                case LEFT: {
                    rightSpace = space;
                    break;
                }
                case RIGHT: {
                    leftSpace = space;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.alignment.name());
                }
            }
        }
        for (i = 0; i < leftSpace; ++i) {
            target.append(this.filler);
        }
        if (space < 0 && this.mode == '|') {
            target.append(value.subSequence(0, this.width));
        } else {
            target.append(value);
        }
        for (i = 0; i < rightSpace; ++i) {
            target.append(this.filler);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(this.filler);
        sb.append(this.alignment);
        sb.append(this.width);
        return sb.toString();
    }
}

