/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.mmm.util.lang.api.LocaleHelper;
import net.sf.mmm.util.text.api.Hyphenator;
import net.sf.mmm.util.text.api.HyphenatorBuilder;
import net.sf.mmm.util.text.api.StringHasher;
import net.sf.mmm.util.text.base.AbstractHyphenatorBuilder;
import net.sf.mmm.util.text.base.FastStringHasher;
import net.sf.mmm.util.text.base.HyphenatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HyphenatorBuilderImpl
extends AbstractHyphenatorBuilder {
    public static final String HYPHENATION_XML_CONFIG_PREFIX = "net/sf/mmm/util/text/hyphenation";
    public static final String HYPHENATION_XML_CONFIG_SUFFIX = ".xml";
    private static final String XML_TAG_HYPHENATION = "hyphenation";
    private static final String XML_ATR_HYPHEN = "hyphen";
    private static final String XML_TAG_EXCEPTION_LIST = "exceptions";
    private static final String XML_TAG_PATTERN_LIST = "patterns";
    private static final String XML_TAG_EXCEPTION = "e";
    private static final String XML_TAG_PATTERN = "p";
    private static HyphenatorBuilder instance;
    private StringHasher stringHasher;

    protected void doInitialize() {
        super.doInitialize();
        if (this.stringHasher == null) {
            this.stringHasher = new FastStringHasher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenatorBuilder getInstance() {
        if (instance != null) return instance;
        Class<HyphenatorBuilderImpl> clazz = HyphenatorBuilderImpl.class;
        synchronized (HyphenatorBuilderImpl.class) {
            if (instance != null) return instance;
            HyphenatorBuilderImpl impl = new HyphenatorBuilderImpl();
            impl.initialize();
            instance = impl;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected Hyphenator createHyphenator(String localeInfix) {
        String classpath = HYPHENATION_XML_CONFIG_PREFIX + localeInfix + HYPHENATION_XML_CONFIG_SUFFIX;
        URL url = Thread.currentThread().getContextClassLoader().getResource(classpath);
        if (url != null) {
            Locale locale = LocaleHelper.getLocale((String)localeInfix);
            return this.createHyphenator(locale, url);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Hyphenator createHyphenator(Locale locale, URL resource) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XmlHandler handler = new XmlHandler();
            try (InputStream inputStream = resource.openStream();){
                saxParser.parse(inputStream, (DefaultHandler)handler);
                if (handler.patterns.isEmpty()) {
                    throw new IllegalStateException("No patterns in XML config!");
                }
                HyphenatorImpl hyphenator = new HyphenatorImpl(locale, handler.hyphen, handler.patterns, handler.exceptions, this.stringHasher);
                hyphenator.initialize();
                HyphenatorImpl hyphenatorImpl = hyphenator;
                return hyphenatorImpl;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error parsing XML from " + resource, e);
        }
    }

    protected StringHasher getStringHasher() {
        return this.stringHasher;
    }

    public void setStringHasher(StringHasher stringHasher) {
        this.getInitializationState().requireNotInitilized();
        this.stringHasher = stringHasher;
    }

    private static class XmlHandler
    extends DefaultHandler {
        private boolean rootPresent;
        private char hyphen = (char)45;
        private List<String> patterns;
        private List<String> exceptions;
        private List<String> activeList;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.activeList = null;
            if (!this.rootPresent) {
                if (!qName.equals(HyphenatorBuilderImpl.XML_TAG_HYPHENATION)) {
                    throw new IllegalStateException("Invalid root tag '" + qName + "'.");
                }
                this.rootPresent = true;
                String hyp = attributes.getValue(HyphenatorBuilderImpl.XML_ATR_HYPHEN);
                if (hyp != null) {
                    if (hyp.length() == 1) {
                        this.hyphen = hyp.charAt(0);
                    } else {
                        throw new IllegalStateException("Invalid hypen character '" + hyp + "'.");
                    }
                }
            }
            if (qName.equals(HyphenatorBuilderImpl.XML_TAG_PATTERN)) {
                this.activeList = this.patterns;
            } else if (qName.equals(HyphenatorBuilderImpl.XML_TAG_EXCEPTION)) {
                this.activeList = this.exceptions;
            } else if (qName.equals(HyphenatorBuilderImpl.XML_TAG_PATTERN_LIST)) {
                if (this.patterns == null) {
                    this.patterns = new ArrayList<String>();
                }
            } else if (qName.equals(HyphenatorBuilderImpl.XML_TAG_EXCEPTION_LIST) && this.exceptions == null) {
                this.exceptions = new ArrayList<String>();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.activeList = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.activeList != null) {
                this.activeList.add(new String(ch, start, length));
            }
        }
    }
}

