/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.util.Arrays;
import net.sf.mmm.util.text.api.Hyphenation;

public class HyphenationImpl
implements Hyphenation {
    private final String word;
    private final int[] hyphenationPoints;
    private final char hyphen;

    public HyphenationImpl(String word, char hyphen, int[] hyphenationPoints) {
        this.word = word;
        this.hyphen = hyphen;
        this.hyphenationPoints = hyphenationPoints;
    }

    public HyphenationImpl(String hyphenatedWord) {
        this(hyphenatedWord, '-');
    }

    public HyphenationImpl(String hyphenatedWord, char hyphen) {
        this.hyphen = hyphen;
        int length = hyphenatedWord.length();
        StringBuilder wordBuilder = new StringBuilder(length);
        int maxPointsLength = length - 2;
        if (maxPointsLength < 0) {
            maxPointsLength = 0;
        }
        int[] points = new int[maxPointsLength];
        int hyphenationPointCount = 0;
        for (int i = 0; i < length; ++i) {
            char c = hyphenatedWord.charAt(i);
            if (c == hyphen) {
                if (hyphenationPointCount >= points.length) {
                    throw new IllegalArgumentException(hyphenatedWord);
                }
                points[hyphenationPointCount] = wordBuilder.length();
                ++hyphenationPointCount;
                continue;
            }
            wordBuilder.append(c);
        }
        this.hyphenationPoints = Arrays.copyOf(points, hyphenationPointCount);
        this.word = wordBuilder.toString();
    }

    @Override
    public int getHyphenationCount() {
        return this.hyphenationPoints.length;
    }

    @Override
    public int getHyphenation(int hyphenationIndex) {
        return this.hyphenationPoints[hyphenationIndex];
    }

    @Override
    public int getHyphenationBefore(int offset) {
        int result = -1;
        for (int i = this.hyphenationPoints.length - 1; i >= 0; --i) {
            if (this.hyphenationPoints[i] >= offset) continue;
            result = this.hyphenationPoints[i];
            break;
        }
        return result;
    }

    public int[] getHyphenationPoints() {
        return this.hyphenationPoints;
    }

    @Override
    public String getWord() {
        return this.word;
    }

    @Override
    public char getHyphen() {
        return this.hyphen;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.word.length() + 4);
        int start = 0;
        int[] nArray = this.hyphenationPoints;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int offset;
            int end = offset = nArray[i];
            result.append(this.word, start, end);
            result.append(this.hyphen);
            start = end;
        }
        result.append(this.word, start, this.word.length());
        return result.toString();
    }
}

