/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import net.sf.mmm.util.text.base.AbstractStringHasher;

public class FastStringHasher
extends AbstractStringHasher {
    private static final int HASH_FACTOR = 31;

    @Override
    public int getHashCode(char[] string, int start, int end) {
        int hash = 0;
        for (int i = start; i < end; ++i) {
            hash = hash * 31 + string[i];
        }
        return hash;
    }

    @Override
    public int getHashCode(CharSequence string, int start, int end) {
        int hash = 0;
        for (int i = start; i < end; ++i) {
            hash = hash * 31 + string.charAt(i);
        }
        return hash;
    }

    @Override
    public int[] getHashCodes(char[] string, int length, int stringStart, int stringEnd) {
        int[] hashCodes;
        int wordLength = stringEnd - stringStart;
        if (wordLength <= 0) {
            return AbstractStringHasher.EMPTY_INT_ARRAY;
        }
        int hashCodesSize = wordLength - length + 1;
        if (hashCodesSize > 0) {
            hashCodes = new int[hashCodesSize];
            int hash = 0;
            int powFactor = 0;
            int stop = length + stringStart;
            for (int stringIndex = stringStart; stringIndex < stop; ++stringIndex) {
                hash = hash * 31 + string[stringIndex];
                if (powFactor == 0) {
                    powFactor = 1;
                    continue;
                }
                powFactor *= 31;
            }
            hashCodes[0] = hash;
            int headIndex = stringStart;
            int tailIndex = stringStart + length;
            for (int hashCodesIndex = 1; hashCodesIndex < hashCodesSize; ++hashCodesIndex) {
                hash -= powFactor * string[headIndex++];
                hashCodes[hashCodesIndex] = hash = hash * 31 + string[tailIndex++];
            }
        } else {
            hashCodes = AbstractStringHasher.EMPTY_INT_ARRAY;
        }
        return hashCodes;
    }
}

