/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.base;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import javax.inject.Inject;
import net.sf.mmm.util.text.api.Hyphenation;
import net.sf.mmm.util.text.api.Hyphenator;
import net.sf.mmm.util.text.api.HyphenatorBuilder;
import net.sf.mmm.util.text.api.TextColumn;
import net.sf.mmm.util.text.api.TextColumnInfo;
import net.sf.mmm.util.text.api.TextTableInfo;
import net.sf.mmm.util.text.base.AbstractLineWrapper;
import net.sf.mmm.util.text.base.HyphenatorBuilderImpl;

public class DefaultLineWrapper
extends AbstractLineWrapper {
    private HyphenatorBuilder hyphenatorBuilder;

    protected HyphenatorBuilder getHyphenatorBuilder() {
        return this.hyphenatorBuilder;
    }

    @Inject
    public void setHyphenatorBuilder(HyphenatorBuilder hyphenatorBuilder) {
        this.getInitializationState().requireNotInitilized();
        this.hyphenatorBuilder = hyphenatorBuilder;
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.hyphenatorBuilder == null) {
            this.hyphenatorBuilder = HyphenatorBuilderImpl.getInstance();
        }
    }

    protected void autoAdjustWidthOfColumns(ColumnState[] columnStates, TextTableInfo tableInfo) {
        block21: {
            int widthRemaining;
            long autoAdjustColumnTotalTextLength;
            int autoAdjustColumnCount;
            block22: {
                int tableWidth = tableInfo.getWidth();
                if (tableWidth == -1) {
                    for (int i = 0; i < columnStates.length; ++i) {
                        if (columnStates[i].width != -1) continue;
                        throw new IllegalArgumentException("Width of table info and column states (" + i + ") can not both be set to auto adjust.");
                    }
                    return;
                }
                if (tableWidth <= 0) {
                    throw new IllegalArgumentException("tableInfo.width==" + tableWidth);
                }
                autoAdjustColumnCount = 0;
                int staticTableWidth = 0;
                ColumnState lastAutoAdjustColumn = null;
                autoAdjustColumnTotalTextLength = 0L;
                for (int i = 0; i < columnStates.length; ++i) {
                    TextColumnInfo columnInfo = columnStates[i].getColumnInfo();
                    staticTableWidth += columnInfo.getBorderWidth();
                    int width = columnStates[i].width;
                    if (width == -1) {
                        ++autoAdjustColumnCount;
                        lastAutoAdjustColumn = columnStates[i];
                        autoAdjustColumnTotalTextLength += (long)columnStates[i].getText().length();
                        continue;
                    }
                    staticTableWidth += width;
                }
                widthRemaining = tableWidth - staticTableWidth;
                if (widthRemaining < autoAdjustColumnCount) {
                    throw new IllegalArgumentException("Table width (" + tableWidth + ") may not be less than static width + auto adjust column count (" + (staticTableWidth + autoAdjustColumnCount) + ")");
                }
                if (autoAdjustColumnCount <= 0) break block21;
                if (autoAdjustColumnCount != 1) break block22;
                lastAutoAdjustColumn.width = widthRemaining;
                break block21;
            }
            AutoAdjustInfo[] autoAdjustInfoArray = new AutoAdjustInfo[autoAdjustColumnCount];
            int autoAdjustInfoIndex = 0;
            int widthUsed = 0;
            for (int i = 0; i < columnStates.length; ++i) {
                AutoAdjustInfo autoAdjustInfo;
                if (columnStates[i].getColumnInfo().getWidth() != -1) continue;
                autoAdjustInfoArray[autoAdjustInfoIndex] = autoAdjustInfo = new AutoAdjustInfo(columnStates[i]);
                double ratio = autoAdjustInfo.getTextLengthRation(autoAdjustColumnTotalTextLength);
                int calculatedWidth = (int)((double)widthRemaining * ratio);
                if (calculatedWidth < 1 && ratio > 0.0) {
                    calculatedWidth = 1;
                }
                if (calculatedWidth > autoAdjustInfo.lineLengthMax) {
                    calculatedWidth = autoAdjustInfo.lineLengthMax;
                }
                autoAdjustInfo.columnState.setWidth(calculatedWidth);
                widthUsed += calculatedWidth;
                ++autoAdjustInfoIndex;
            }
            int delta = widthUsed - widthRemaining;
            if (delta == 0) break block21;
            TreeSet<AutoAdjustInfo> autoAdjustInfoSet = new TreeSet<AutoAdjustInfo>();
            if (delta > 0) {
                for (AutoAdjustInfo autoAdjustInfo : autoAdjustInfoArray) {
                    if (autoAdjustInfo.columnState.width < 2) continue;
                    autoAdjustInfoSet.add(autoAdjustInfo);
                }
                while (delta > 0) {
                    Iterator iterator = autoAdjustInfoSet.iterator();
                    if (!iterator.hasNext()) {
                        throw new IllegalStateException();
                    }
                    while (iterator.hasNext()) {
                        AutoAdjustInfo autoAdjustInfo = (AutoAdjustInfo)iterator.next();
                        autoAdjustInfo.columnState.width--;
                        if (--delta == 0) {
                            return;
                        }
                        if (autoAdjustInfo.columnState.width >= 2) continue;
                        iterator.remove();
                    }
                }
            } else {
                for (AutoAdjustInfo autoAdjustInfo : autoAdjustInfoArray) {
                    if (autoAdjustInfo.columnState.width >= autoAdjustInfo.lineLengthMax) continue;
                    autoAdjustInfoSet.add(autoAdjustInfo);
                }
                while (delta < 0) {
                    Iterator iterator = autoAdjustInfoSet.iterator();
                    if (!iterator.hasNext()) {
                        return;
                    }
                    while (iterator.hasNext()) {
                        AutoAdjustInfo autoAdjustInfo = (AutoAdjustInfo)iterator.next();
                        autoAdjustInfo.columnState.width++;
                        if (++delta == 0) {
                            return;
                        }
                        if (autoAdjustInfo.columnState.width < autoAdjustInfo.lineLengthMax) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    @Override
    public int wrap(Appendable appendable, TextTableInfo tableInfo, TextColumn ... columns) {
        try {
            Objects.requireNonNull(appendable, "appendable");
            Objects.requireNonNull(tableInfo, "tableInfo");
            Objects.requireNonNull(columns, "columns");
            if (columns.length == 0) {
                throw new IllegalArgumentException("columns.length==0");
            }
            int newLines = 0;
            boolean todo = true;
            ColumnState[] columnStates = new ColumnState[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                columnStates[i] = new ColumnState(columns[i].getText(), columns[i].getColumnInfo(), this.hyphenatorBuilder);
            }
            this.autoAdjustWidthOfColumns(columnStates, tableInfo);
            assert (this.verifyWithOfColumns(columnStates, tableInfo));
            CellBuffer textFragmentBuilder = new CellBuffer();
            while (todo) {
                todo = false;
                for (int columnIndex = 0; columnIndex < columnStates.length; ++columnIndex) {
                    ColumnState state = columnStates[columnIndex];
                    appendable.append(state.getColumnInfo().getBorderLeft());
                    this.append(appendable, state, textFragmentBuilder);
                    if (!state.isComplete()) {
                        todo = true;
                    }
                    appendable.append(state.getColumnInfo().getBorderRight());
                }
                appendable.append(tableInfo.getLineSeparator());
                ++newLines;
            }
            return newLines;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not write to Appendable", e);
        }
    }

    private boolean verifyWithOfColumns(ColumnState[] columnStates, TextTableInfo tableInfo) {
        int tableWidth = tableInfo.getWidth();
        if (tableWidth != -1) {
            int calculatedWidth = 0;
            for (ColumnState columnState : columnStates) {
                if (columnState.width < 0) {
                    throw new AssertionError((Object)("columnWidth=" + columnState.width));
                }
                calculatedWidth = calculatedWidth + columnState.width + columnState.getColumnInfo().getBorderWidth();
            }
            if (calculatedWidth != tableWidth) {
                throw new AssertionError((Object)("with=" + tableWidth + ", sum-of-columns=" + calculatedWidth));
            }
        }
        return true;
    }

    private static boolean isIn(char c, char[] chars) {
        if (chars != null) {
            for (char current : chars) {
                if (current != c) continue;
                return true;
            }
        }
        return false;
    }

    protected void appendCellBuffer(ColumnState state, CellBuffer buffer) {
        int bufferRest = buffer.getRest();
        boolean hyphenationActive = buffer.maxLength >= 4;
        boolean todo = true;
        while (todo) {
            TextSegment currentSegment = state.currentSegment;
            if (currentSegment.getType() == TextSegmentType.NEWLINE) {
                switch (state.getColumnInfo().getIndentationMode()) {
                    case NO_INDENT_AFTER_NEWLINE: {
                        state.indent = false;
                        break;
                    }
                    case NO_INDENT_AFTER_DOUBLE_NEWLINE: {
                        if (state.getSubsequentNewlineCount() >= 2) {
                            state.indent = false;
                            break;
                        }
                        state.indent = true;
                        break;
                    }
                    case INDENT_AFTER_NEWLINE: {
                        state.indent = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("" + (Object)((Object)state.getColumnInfo().getIndentationMode()));
                    }
                }
                state.proceedTextSegment();
                todo = false;
                continue;
            }
            int segmentStartOffset = state.textIndex - currentSegment.startIndex;
            int segmentRest = currentSegment.getLength() - segmentStartOffset;
            int space = bufferRest - segmentRest;
            TextSegmentType nextType = null;
            if (state.nextSegment != null) {
                nextType = state.nextSegment.type;
            }
            if (hyphenationActive) {
                if (TextSegmentType.PUNCTUATION_CHARACTER == nextType) {
                    --space;
                } else if (TextSegmentType.NON_BREAKING_CHARACTER == nextType) {
                    --space;
                }
            }
            if (space >= 0) {
                bufferRest = buffer.append(currentSegment.text, state.textIndex, currentSegment.endIndex);
                todo = state.proceedTextSegment();
                continue;
            }
            if (hyphenationActive && currentSegment.getType() == TextSegmentType.WORD) {
                int end;
                int hyphenationPoint;
                int hyphenationOffset;
                Hyphenation hyphenation = currentSegment.getHyphenatedWord();
                int hyphenationBefore = currentSegment.getLength() + space;
                if (hyphenationBefore == currentSegment.endIndex) {
                    ++hyphenationBefore;
                }
                if ((hyphenationOffset = (hyphenationPoint = hyphenation.getHyphenationBefore(hyphenationBefore)) - segmentStartOffset) <= 0) {
                    int fillRatio = bufferRest > 6 ? 0 : (bufferRest <= 2 ? Integer.MAX_VALUE : buffer.length() / bufferRest);
                    if (fillRatio <= 3) {
                        hyphenationOffset = bufferRest - 1;
                    } else {
                        todo = false;
                        break;
                    }
                }
                if ((end = state.textIndex + hyphenationOffset) + 1 == currentSegment.endIndex) {
                    --end;
                }
                bufferRest = buffer.append(currentSegment.text, state.textIndex, end);
                if (end < currentSegment.endIndex) {
                    bufferRest = buffer.append(state.hyphenator.getHyphen());
                } else {
                    todo = state.proceedTextSegment();
                }
                state.textIndex = end;
                todo = false;
                continue;
            }
            int end = state.textIndex + bufferRest;
            buffer.append(currentSegment.text, state.textIndex, end);
            state.textIndex = end;
            todo = false;
        }
    }

    protected void append(Appendable appendable, ColumnState state, CellBuffer cellBuffer) throws IOException {
        boolean doIndentThisLine = false;
        int width = state.getWidth();
        if (state.isComplete()) {
            cellBuffer.reset(width);
        } else {
            TextColumnInfo columnInfo = state.getColumnInfo();
            if (width >= 4) {
                if (state.indent) {
                    doIndentThisLine = true;
                    width -= columnInfo.getIndent().length();
                    String text = state.getText();
                    while (DefaultLineWrapper.isIn(text.charAt(state.textIndex), columnInfo.getOmitChars())) {
                        boolean todo;
                        state.textIndex++;
                        if (state.textIndex < state.currentSegment.endIndex || (todo = state.proceedTextSegment())) continue;
                        break;
                    }
                }
                state.indent = true;
            }
            cellBuffer.reset(width);
            this.appendCellBuffer(state, cellBuffer);
        }
        this.appendWithAlignment(appendable, state, doIndentThisLine, cellBuffer);
    }

    protected void appendWithAlignment(Appendable appendable, ColumnState state, boolean doIndentThisLine, CellBuffer cellBuffer) throws IOException {
        int space = cellBuffer.getRest();
        assert (space >= 0);
        TextColumnInfo columnInfo = state.getColumnInfo();
        switch (columnInfo.getAlignment()) {
            case LEFT: {
                if (doIndentThisLine) {
                    appendable.append(columnInfo.getIndent());
                }
                appendable.append(cellBuffer.buffer);
                this.fill(appendable, columnInfo.getFiller(), space);
                break;
            }
            case RIGHT: {
                this.fill(appendable, columnInfo.getFiller(), space);
                appendable.append(cellBuffer.buffer);
                if (!doIndentThisLine) break;
                appendable.append(columnInfo.getIndent());
                break;
            }
            case CENTER: {
                int leftSpace = space / 2;
                int rightSpace = space - leftSpace;
                this.fill(appendable, columnInfo.getFiller(), leftSpace);
                String rightIndent = "";
                if (doIndentThisLine) {
                    String indent = columnInfo.getIndent();
                    int indentLength = indent.length();
                    int rightIndex = indentLength - indentLength / 2;
                    String leftIndent = indent.substring(0, rightIndex);
                    rightIndent = indent.substring(rightIndex);
                    appendable.append(leftIndent);
                }
                appendable.append(cellBuffer.buffer);
                if (doIndentThisLine) {
                    appendable.append(rightIndent);
                }
                this.fill(appendable, columnInfo.getFiller(), rightSpace);
                break;
            }
            default: {
                throw new IllegalStateException("" + columnInfo.getAlignment());
            }
        }
    }

    protected void fill(Appendable appendable, char filler, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            appendable.append(filler);
        }
    }

    protected static final class AutoAdjustInfo
    implements Comparable<AutoAdjustInfo> {
        private final ColumnState columnState;
        private int lineCount;
        private int lineLengthMax;

        private AutoAdjustInfo(ColumnState columnState) {
            this.columnState = columnState;
            String text = columnState.getText();
            int textLength = text.length();
            int index = 0;
            while (index >= 0) {
                ++this.lineCount;
                int nextIndex = text.indexOf("\n", index);
                int length = nextIndex - index;
                if (nextIndex < 0) {
                    length = textLength - index;
                    index = -1;
                } else {
                    index = nextIndex + 1;
                }
                if (length <= this.lineLengthMax) continue;
                this.lineLengthMax = length;
            }
        }

        public int getLineCount() {
            return this.lineCount;
        }

        @Override
        public int compareTo(AutoAdjustInfo other) {
            Objects.requireNonNull(other);
            return this.columnState.width - other.columnState.width;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.columnState == null ? 0 : this.columnState.hashCode());
            result = 31 * result + this.lineCount;
            result = 31 * result + this.lineLengthMax;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutoAdjustInfo other = (AutoAdjustInfo)obj;
            if (this.columnState == null ? other.columnState != null : !this.columnState.equals(other.columnState)) {
                return false;
            }
            if (this.lineCount != other.lineCount) {
                return false;
            }
            return this.lineLengthMax == other.lineLengthMax;
        }

        public double getTextLengthRation(double totalTextLength) {
            if (totalTextLength == 0.0) {
                return 0.0;
            }
            return (double)this.columnState.getText().length() / totalTextLength;
        }
    }

    protected static class CellBuffer {
        private final StringBuilder buffer = new StringBuilder();
        private int maxLength = 0;
        private int rest = 0;

        protected CellBuffer() {
        }

        protected void reset(int maximumLength) {
            this.buffer.setLength(0);
            this.maxLength = maximumLength;
            this.rest = maximumLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getRest() {
            return this.rest;
        }

        protected int append(CharSequence text) {
            this.buffer.append(text);
            this.rest = this.maxLength - this.buffer.length();
            assert (this.rest >= 0);
            return this.rest;
        }

        protected int append(CharSequence text, int start, int end) {
            if (text.subSequence(start, end).toString().contains("\n")) {
                throw new IllegalStateException();
            }
            this.buffer.append(text, start, end);
            this.rest -= end - start;
            assert (this.rest >= 0);
            return this.rest;
        }

        protected int append(char c) {
            this.buffer.append(c);
            --this.rest;
            assert (this.rest >= 0);
            return this.rest;
        }

        protected int length() {
            return this.buffer.length();
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    protected static class ColumnState
    extends TextColumn {
        private final Hyphenator hyphenator;
        private final BreakIterator breakIterator;
        private int breakIteratorIndex;
        private int segmentIndex;
        private int textIndex;
        private int width;
        private boolean indent;
        private TextSegment currentSegment;
        private TextSegment nextSegment;
        private int subsequentNewlineCount;

        public ColumnState(String text, TextColumnInfo columnInfo, HyphenatorBuilder hyphenatorBuilder) {
            super(text, columnInfo);
            Locale locale = columnInfo.getLocale();
            this.breakIterator = BreakIterator.getLineInstance(locale);
            this.breakIterator.setText(text);
            this.hyphenator = hyphenatorBuilder.getHyphenator(locale);
            this.segmentIndex = 0;
            this.textIndex = 0;
            this.width = columnInfo.getWidth();
            this.breakIteratorIndex = 0;
            this.subsequentNewlineCount = 0;
            this.indent = false;
            if (columnInfo.getIndent() == null || columnInfo.getWidth() != -1 && columnInfo.getIndent().length() >= columnInfo.getWidth()) {
                throw new IllegalArgumentException("TextColumnInfo.indent == " + columnInfo.getIndent());
            }
            this.currentSegment = this.next(new TextSegment(text, this.hyphenator));
            this.nextSegment = this.next(new TextSegment(text, this.hyphenator));
        }

        public TextSegment getCurrentSegment() {
            return this.currentSegment;
        }

        public TextSegment getNextSegment() {
            return this.nextSegment;
        }

        public int getSubsequentNewlineCount() {
            return this.subsequentNewlineCount;
        }

        public boolean proceedTextSegment() {
            if (this.currentSegment == null) {
                return false;
            }
            this.textIndex = this.currentSegment.endIndex;
            TextSegment old = this.currentSegment;
            this.currentSegment = this.nextSegment;
            this.nextSegment = this.next(old);
            if (this.currentSegment == null) {
                this.subsequentNewlineCount = 0;
                return false;
            }
            this.subsequentNewlineCount = this.currentSegment.type == TextSegmentType.NEWLINE ? ++this.subsequentNewlineCount : 0;
            return true;
        }

        private TextSegment next(TextSegment textSegment) {
            String text = this.getText();
            int length = text.length();
            if (this.segmentIndex >= length) {
                return null;
            }
            if (this.breakIteratorIndex != -1 && this.breakIteratorIndex <= this.segmentIndex) {
                this.breakIteratorIndex = this.breakIterator.next();
            }
            int newIndex = this.segmentIndex;
            char firstChar = text.charAt(newIndex++);
            int end = this.breakIteratorIndex;
            if (end == -1) {
                end = length;
            }
            TextSegmentType type = ColumnState.getCharacterType(firstChar);
            switch (type) {
                case NEWLINE: {
                    char next;
                    if (newIndex >= end || ColumnState.getCharacterType(next = text.charAt(newIndex)) != TextSegmentType.NEWLINE || next == firstChar) break;
                    ++newIndex;
                    break;
                }
                case WORD: {
                    while (newIndex < end && Character.isLetter(text.charAt(newIndex))) {
                        ++newIndex;
                    }
                    break;
                }
                case PUNCTUATION_CHARACTER: {
                    break;
                }
                case NON_BREAKING_CHARACTER: {
                    break;
                }
                case CHARACTERS: {
                    char c;
                    while (newIndex < end && ColumnState.getCharacterType(c = text.charAt(newIndex)) == TextSegmentType.CHARACTERS) {
                        ++newIndex;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("" + (Object)((Object)type));
                }
            }
            textSegment.initialize(this.segmentIndex, newIndex, type);
            this.segmentIndex = newIndex;
            return textSegment;
        }

        private static TextSegmentType getCharacterType(char c) {
            if (c == '\n' || c == '\r') {
                return TextSegmentType.NEWLINE;
            }
            if (c == '\u00a0' || c == ',' || c == '!' || c == ';' || c == '?') {
                return TextSegmentType.NON_BREAKING_CHARACTER;
            }
            if (c == '.' || c == ',' || c == '!' || c == ';' || c == '?') {
                return TextSegmentType.PUNCTUATION_CHARACTER;
            }
            if (Character.isLetter(c)) {
                return TextSegmentType.WORD;
            }
            return TextSegmentType.CHARACTERS;
        }

        public int getTextIndex() {
            return this.textIndex;
        }

        public void setTextIndex(int textIndex) {
            this.textIndex = textIndex;
        }

        public boolean isIndent() {
            return this.indent;
        }

        public void setIndent(boolean indent) {
            this.indent = indent;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isComplete() {
            return this.textIndex >= this.getText().length();
        }
    }

    protected static class TextSegment {
        private final String text;
        private final Hyphenator hyphenator;
        private int startIndex;
        private int endIndex;
        private TextSegmentType type;
        private Hyphenation hyphenatedWord;

        protected TextSegment(String text, Hyphenator hyphenator) {
            this.text = text;
            this.hyphenator = hyphenator;
        }

        public int getLength() {
            return this.endIndex - this.startIndex;
        }

        public void initialize(int start, int end, TextSegmentType textType) {
            this.hyphenatedWord = null;
            this.startIndex = start;
            this.endIndex = end;
            this.type = textType;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getText() {
            return this.text;
        }

        public TextSegmentType getType() {
            return this.type;
        }

        public Hyphenation getHyphenatedWord() {
            if (this.type == TextSegmentType.WORD && this.hyphenatedWord == null) {
                this.hyphenatedWord = this.hyphenator.hyphenate(this.getText(), this.getStartIndex(), this.getEndIndex());
            }
            return this.hyphenatedWord;
        }

        public String toString() {
            return this.text.substring(this.startIndex, this.endIndex);
        }
    }

    protected static enum TextSegmentType {
        WORD,
        NEWLINE,
        NON_BREAKING_CHARACTER,
        PUNCTUATION_CHARACTER,
        CHARACTERS;

    }
}

