/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.base;

import java.util.Locale;
import java.util.UUID;
import net.sf.mmm.util.exception.api.BusinessErrorUserException;
import net.sf.mmm.util.exception.api.ExceptionTruncation;
import net.sf.mmm.util.exception.api.ExceptionUtil;
import net.sf.mmm.util.exception.api.GenericSerializableException;
import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.exception.api.TechnicalErrorUserException;
import net.sf.mmm.util.exception.base.ExceptionUtilLimitedImpl;
import net.sf.mmm.util.session.api.UserSessionAccess;
import net.sf.mmm.util.uuid.api.UuidAccess;

@Deprecated
public class ExceptionUtilImpl
extends ExceptionUtilLimitedImpl
implements ExceptionUtil {
    private static ExceptionUtil instance;
    private boolean enforceSerializableForClient = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExceptionUtil getInstance() {
        if (instance != null) return instance;
        Class<ExceptionUtilImpl> clazz = ExceptionUtilImpl.class;
        synchronized (ExceptionUtilImpl.class) {
            if (instance != null) return instance;
            instance = new ExceptionUtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isEnforceSerializableForClient() {
        return this.enforceSerializableForClient;
    }

    public void setEnforceSerializableForClient(boolean enforceSerializableForClient) {
        this.getInitializationState().requireNotInitilized();
        this.enforceSerializableForClient = enforceSerializableForClient;
    }

    @Override
    public Throwable convertForSerialization(Throwable exception, ExceptionTruncation truncation) {
        String message;
        boolean technical;
        String code;
        UUID uuid;
        String originalExceptionName = exception.getClass().getName();
        Throwable cause = null;
        if (!truncation.isRemoveCause()) {
            cause = this.convertForSerialization(cause, truncation);
        }
        StackTraceElement[] stacktrace = NO_STACKTRACE;
        if (!truncation.isRemoveStacktrace()) {
            stacktrace = exception.getStackTrace();
        }
        if (exception instanceof NlsThrowable) {
            NlsThrowable nlsThrowable = (NlsThrowable)((Object)exception);
            uuid = nlsThrowable.getUuid();
            code = nlsThrowable.getCode();
            technical = nlsThrowable.isTechnical();
            Locale locale = UserSessionAccess.getUserLocale();
            message = nlsThrowable.getLocalizedMessage(locale);
        } else {
            message = exception.getMessage();
            technical = true;
            code = exception.getClass().getSimpleName();
            uuid = UuidAccess.getFactory().createUuid();
        }
        GenericSerializableException serializableException = new GenericSerializableException(cause, message, originalExceptionName, stacktrace, technical, code, uuid);
        if (!truncation.isRemoveSuppressed()) {
            for (Throwable suppressed : exception.getSuppressed()) {
                serializableException.addSuppressed(this.convertForSerialization(suppressed, truncation));
            }
        }
        return serializableException;
    }

    @Override
    public Throwable convertForUser(Throwable exception, ExceptionTruncation truncation) {
        Throwable result = this.convertForUser(exception);
        if (truncation.isRetainAll()) {
            return result;
        }
        NlsThrowable nlsThrowable = result instanceof NlsThrowable ? (NlsThrowable)((Object)result) : TechnicalErrorUserException.getOrCreateUserException(result);
        return nlsThrowable.createCopy(truncation);
    }

    @Override
    public Throwable convertForClient(Throwable exception) {
        ExceptionTruncation truncation = this.getTruncationForClient();
        if (this.isEnforceSerializableForClient()) {
            return this.convertForSerialization(this.convertForUser(exception), truncation);
        }
        return this.convertForUser(exception, truncation);
    }

    protected Throwable obfuscateException(Throwable exception) {
        NlsThrowable nlsThrowable;
        NlsRuntimeException obfuscatedException = null;
        if (exception instanceof NlsThrowable && (nlsThrowable = (NlsThrowable)((Object)exception)).isForUser()) {
            obfuscatedException = new BusinessErrorUserException(nlsThrowable.getNlsMessage());
        }
        if (obfuscatedException == null) {
            obfuscatedException = new TechnicalErrorUserException(null);
        }
        return obfuscatedException;
    }

    protected boolean isRemoveStacktrace() {
        return true;
    }

    protected ExceptionTruncation getTruncationForClient() {
        return ExceptionTruncation.REMOVE_ALL;
    }
}

