/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception;

import java.lang.reflect.Type;
import javax.inject.Named;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.api.NlsBundleMessage;
import net.sf.mmm.util.nls.api.NlsMessage;

public interface NlsBundleUtilExceptionRoot
extends NlsBundle {
    @NlsBundleMessage(value="Failed to parse \"{value}\" - expected \"{type}\"!")
    public NlsMessage errorParseExpected(@Named(value="value") Object var1, @Named(value="type") Object var2);

    @NlsBundleMessage(value="Failed to parse \"{value}\"{source,choice,(?==null)''(else)' from \"'{source}'\"'} as value of the type \"{type}\"!")
    public NlsMessage errorParseType(@Named(value="value") Object var1, @Named(value="type") Object var2, @Named(value="source") Object var3);

    @NlsBundleMessage(value="Failed to parse \"{value}\"{source,choice,(?==null)''(else)' from \"'{source}'\"'} as \"{type}\" - required format is \"{format}\"!")
    public NlsMessage errorParseFormat(@Named(value="value") Object var1, @Named(value="format") Object var2, @Named(value="type") Object var3, @Named(value="source") Object var4);

    @NlsBundleMessage(value="The given argument \"{value}\" is illegal!")
    public NlsMessage errorIllegalArgument(@Named(value="value") Object var1);

    @NlsBundleMessage(value="The given value \"{value}\" is illegal for the argument \"{name}\"!")
    public NlsMessage errorIllegalArgumentWithName(@Named(value="value") Object var1, @Named(value="name") String var2);

    @NlsBundleMessage(value="The object \"{object}\" is null!")
    public NlsMessage errorArgumentNull(@Named(value="object") Object var1);

    @NlsBundleMessage(value="An unexpected error has occurred! We apologize any inconvenience. Please try again later.")
    public NlsMessage errorTechnical();

    @NlsBundleMessage(value="Duplicate object \"{object}\"!")
    public NlsMessage errorDuplicateObject(@Named(value="object") Object var1);

    @NlsBundleMessage(value="Duplicate object \"{object}\" for key \"{key}\"!")
    public NlsMessage errorDuplicateObjectWithKey(@Named(value="object") Object var1, @Named(value="key") Object var2);

    @NlsBundleMessage(value="Duplicate object \"{object}\" for key \"{key}\" - already mapped to \"{existing}\"!")
    public NlsMessage errorDuplicateObjectWithKeyAndExisting(@Named(value="object") Object var1, @Named(value="key") Object var2, @Named(value="existing") Object var3);

    @NlsBundleMessage(value="Mismatch detected{source,choice,(?==null)''(else)' in \"'{source}'\"'}{property,choice,(?==null)''(else)' for \"'{property}'\"'}: found \"{object}\", but expected \"{expected}\"!")
    public NlsMessage errorObjectMismatch(@Named(value="object") Object var1, @Named(value="expected") Object var2, @Named(value="source") Object var3, @Named(value="property") Object var4);

    @NlsBundleMessage(value="Could NOT find object \"{object}\"{key,choice,(?==null)''(else)' for \"'{key}'\"'}!")
    public NlsMessage errorObjectNotFound(@Named(value="object") Object var1, @Named(value="key") Object var2);

    @NlsBundleMessage(value="Illegal state!")
    public NlsMessage errorIllegalState();

    @NlsBundleMessage(value="The following errors have occurred!\n{error}")
    public NlsMessage errorComposed(@Named(value="error") Object var1);

    @NlsBundleMessage(value="The case \"{case}\" is NOT covered!")
    public NlsMessage errorIllegalCase(@Named(value="case") Object var1);

    @NlsBundleMessage(value="An operation was invoked that is NOT supported!")
    public NlsMessage errorUnsupportedOperation();

    @NlsBundleMessage(value="The operation \"{operation}\" was invoked{source,choice,(?==null)''(else)' on \"'{source}'\"'} but is NOT supported!")
    public NlsMessage errorUnsupportedOperationWithName(@Named(value="operation") Object var1, @Named(value="source") Object var2);

    @NlsBundleMessage(value="Failed to modify{attribute,choice,(?==null)''(else)' attribute \"'{attribute}'\" of'} \"{object}\" as it is read-only!")
    public NlsMessage errorReadOnly(@Named(value="object") Object var1, @Named(value="attribute") Object var2);

    @NlsBundleMessage(value="Can NOT cast \"{object}\" from \"{source}\" to \"{target}\"!")
    public NlsMessage errorCast(@Named(value="object") Object var1, @Named(value="source") Type var2, @Named(value="target") Type var3);

    @NlsBundleMessage(value="The object \"{object}\" has already been disposed!")
    public NlsMessage errorObjectDisposed(@Named(value="object") Object var1);

    @NlsBundleMessage(value="Validation failed - please ensure to provide complete and correct data.")
    public NlsMessage errorValidation();

    @NlsBundleMessage(value="The value \"{value}\"{source,choice,(?==null)''(else)' from \"'{source}'\"'} with the type \"{valueType}\" can NOT be converted to the requested type \"{targetType}\"!")
    public NlsMessage errorValueWrongType(@Named(value="value") Object var1, @Named(value="valueType") Object var2, @Named(value="targetType") Object var3, @Named(value="source") Object var4);

    @NlsBundleMessage(value="The value from \"{source}\" is not set!")
    public NlsMessage errorValueNotSet(@Named(value="source") Object var1);

    @NlsBundleMessage(value="The value {value}{source,choice,(?==null)''(else)' from \"'{source}'\"'} needs to be in the range from {min} to {max}.")
    public NlsMessage errorValueOutOfRange(@Named(value="value") Object var1, @Named(value="min") Object var2, @Named(value="max") Object var3, @Named(value="source") Object var4);

    @NlsBundleMessage(value="The value \"{value}\"{source,choice,(?==null)''(else)' from \"'{source}'\"'} could NOT be converted to \"{type}\"!")
    public NlsMessage errorValueConvert(@Named(value="value") Object var1, @Named(value="type") Type var2, @Named(value="source") Object var3);

    @NlsBundleMessage(value="The operation failed due to a conflict of concurrent modification. Please save your changes via copy and paste or screenshot, reject your changes and repeat the operation. The conflict concerns the entity {entity} with primary key {id}.")
    public NlsMessage errorOptimisticLocking(Object var1, Object var2);

    @NlsBundleMessage(value="While invoking the service {service} the following error occurred: {message}. Probably the service is temporary unavailable. Please try again later. If the problem persists contact your system administrator.")
    public NlsMessage errorServiceInvocationFailed(@Named(value="service") String var1, @Named(value="message") String var2);

    @NlsBundleMessage(value="The operation failed due to security restrictions. Please contact the support in case of a permission problem.")
    public NlsMessage errorSecurityRestriction();
}

