/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jxls.reader.BaseBlockReader;
import net.sf.jxls.reader.BeanCellMapping;
import net.sf.jxls.reader.ReaderConfig;
import net.sf.jxls.reader.SectionCheck;
import net.sf.jxls.reader.SimpleBlockReader;
import net.sf.jxls.reader.XLSDataReadException;
import net.sf.jxls.reader.XLSReadMessage;
import net.sf.jxls.reader.XLSReadStatus;
import net.sf.jxls.reader.XLSRowCursor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;

public class SimpleBlockReaderImpl
extends BaseBlockReader
implements SimpleBlockReader {
    protected final Log log = LogFactory.getLog(this.getClass());
    List beanCellMappings = new ArrayList();
    SectionCheck sectionCheck;

    public SimpleBlockReaderImpl() {
    }

    public SimpleBlockReaderImpl(int startRow, int endRow, List beanCellMappings) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.beanCellMappings = beanCellMappings;
    }

    public SimpleBlockReaderImpl(int startRow, int endRow) {
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public XLSReadStatus read(XLSRowCursor cursor, Map beans) {
        this.readStatus.clear();
        int currentRowNum = cursor.getCurrentRowNum();
        int rowShift = currentRowNum - this.startRow;
        Iterator iterator = this.beanCellMappings.iterator();
        while (iterator.hasNext()) {
            BeanCellMapping mapping = (BeanCellMapping)iterator.next();
            try {
                String dataString = this.readCellString(cursor.getSheet(), mapping.getRow() + rowShift, mapping.getCol());
                mapping.populateBean(dataString, beans);
            }
            catch (Exception e) {
                String message = "Can't read cell " + this.getCellName(mapping, rowShift) + " on " + cursor.getSheetName() + " spreadsheet";
                this.readStatus.addMessage(new XLSReadMessage(message, e));
                if (ReaderConfig.getInstance().isSkipErrors()) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)message);
                    continue;
                }
                this.readStatus.setStatusOK(false);
                throw new XLSDataReadException(this.getCellName(mapping, rowShift), "Can't read cell " + this.getCellName(mapping, rowShift) + " on " + cursor.getSheetName() + " spreadsheet", this.readStatus);
            }
        }
        cursor.setCurrentRowNum(this.endRow + rowShift);
        return this.readStatus;
    }

    private String readCellString(HSSFSheet sheet, int rowNum, short cellNum) {
        HSSFCell cell = this.getCell(sheet, rowNum, cellNum);
        return this.getCellString(cell);
    }

    private String getCellString(HSSFCell cell) {
        String dataString = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 1: {
                    dataString = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    double value = cell.getNumericCellValue();
                    if ((double)((int)value) == value) {
                        dataString = Integer.toString((int)value);
                        break;
                    }
                    dataString = Double.toString(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    dataString = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        return dataString;
    }

    private String getCellName(BeanCellMapping mapping, int rowShift) {
        CellReference currentCellRef = new CellReference(mapping.getRow() + rowShift, (int)mapping.getCol());
        return currentCellRef.toString();
    }

    public SectionCheck getLoopBreakCondition() {
        return this.sectionCheck;
    }

    public void setLoopBreakCondition(SectionCheck sectionCheck) {
        this.sectionCheck = sectionCheck;
    }

    public void addMapping(BeanCellMapping mapping) {
        this.beanCellMappings.add(mapping);
    }

    public List getMappings() {
        return this.beanCellMappings;
    }

    private HSSFCell getCell(HSSFSheet sheet, int rowNum, short cellNum) {
        HSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(cellNum);
    }

    static {
        ReaderConfig.getInstance();
    }
}

