/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

public abstract class Aggregator {
    public static Aggregator getInstance(String function) {
        if (function.equalsIgnoreCase("sum")) {
            return new Sum();
        }
        if (function.equalsIgnoreCase("avg")) {
            return new Average();
        }
        if (function.equalsIgnoreCase("min")) {
            return new Minimum();
        }
        if (function.equalsIgnoreCase("max")) {
            return new Maximum();
        }
        if (function.equalsIgnoreCase("count")) {
            return new Count();
        }
        return null;
    }

    public void add(Object o) {
    }

    public Object getResult() {
        return null;
    }

    static class Count
    extends Aggregator {
        private int count = 0;

        Count() {
        }

        public void add(Object o) {
            if (o != null) {
                ++this.count;
            }
        }

        public Object getResult() {
            return this.count;
        }
    }

    static class Maximum
    extends Aggregator {
        private Object max = null;

        Maximum() {
        }

        public void add(Object o) {
            if (o != null) {
                if (this.max == null) {
                    this.max = o;
                } else if (o instanceof Comparable && ((Comparable)o).compareTo(this.max) > 0) {
                    this.max = o;
                }
            }
        }

        public Object getResult() {
            return this.max;
        }
    }

    static class Minimum
    extends Aggregator {
        private Object min = null;

        Minimum() {
        }

        public void add(Object o) {
            if (o != null) {
                if (this.min == null) {
                    this.min = o;
                } else if (o instanceof Comparable && ((Comparable)o).compareTo(this.min) < 0) {
                    this.min = o;
                }
            }
        }

        public Object getResult() {
            return this.min;
        }
    }

    static class Average
    extends Aggregator {
        private double total = 0.0;
        private double count = 0.0;

        Average() {
        }

        public void add(Object o) {
            if (o instanceof Number) {
                this.total += ((Number)o).doubleValue();
                this.count += 1.0;
            }
        }

        public Object getResult() {
            if (this.count == 0.0) {
                return null;
            }
            return new Double(this.total / this.count);
        }
    }

    static class Sum
    extends Aggregator {
        private double total = 0.0;

        Sum() {
        }

        public void add(Object o) {
            if (o instanceof Number) {
                this.total += ((Number)o).doubleValue();
            }
        }

        public Object getResult() {
            return new Double(this.total);
        }
    }
}

