/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.awt.geom.Point2D;

public class TreeCollapser {
    public void collapse(Layout layout, Forest tree, Object subRoot) throws InstantiationException, IllegalAccessException {
        Tree subTree = TreeUtils.getSubTree((Forest)tree, (Object)subRoot);
        Object parent = null;
        Object edge = null;
        if (tree.getPredecessorCount(subRoot) > 0) {
            parent = tree.getPredecessors(subRoot).iterator().next();
            edge = tree.getInEdges(subRoot).iterator().next();
        }
        tree.removeVertex(subRoot);
        if (parent != null) {
            tree.addEdge(edge, parent, (Object)subTree);
        } else {
            tree.addVertex((Object)subTree);
        }
        layout.setLocation((Object)subTree, (Point2D)layout.apply(subRoot));
    }

    public void expand(Forest tree, Forest subTree) {
        Object parent = null;
        Object edge = null;
        if (tree.getPredecessorCount((Object)subTree) > 0) {
            parent = tree.getPredecessors((Object)subTree).iterator().next();
            edge = tree.getInEdges((Object)subTree).iterator().next();
        }
        tree.removeVertex((Object)subTree);
        TreeUtils.addSubTree((Forest)tree, (Forest)subTree, parent, edge);
    }
}

